/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UntagStreamRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<UntagStreamRequest.Builder, UntagStreamRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(UntagStreamRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(UntagStreamRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<List<String>> TAG_KEY_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagKeyList")
            .getter(getter(UntagStreamRequest::tagKeyList))
            .setter(setter(Builder::tagKeyList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeyList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            STREAM_NAME_FIELD, TAG_KEY_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamARN;

    private final String streamName;

    private final List<String> tagKeyList;

    private UntagStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.streamName = builder.streamName;
        this.tagKeyList = builder.tagKeyList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream that you want to remove tags from.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream that you want to remove tags from.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The name of the stream that you want to remove tags from.
     * </p>
     * 
     * @return The name of the stream that you want to remove tags from.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagKeyList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagKeyList() {
        return tagKeyList != null && !(tagKeyList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the keys of the tags that you want to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagKeyList} method.
     * </p>
     * 
     * @return A list of the keys of the tags that you want to remove.
     */
    public final List<String> tagKeyList() {
        return tagKeyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagKeyList() ? tagKeyList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagStreamRequest)) {
            return false;
        }
        UntagStreamRequest other = (UntagStreamRequest) obj;
        return Objects.equals(streamARN(), other.streamARN()) && Objects.equals(streamName(), other.streamName())
                && hasTagKeyList() == other.hasTagKeyList() && Objects.equals(tagKeyList(), other.tagKeyList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UntagStreamRequest").add("StreamARN", streamARN()).add("StreamName", streamName())
                .add("TagKeyList", hasTagKeyList() ? tagKeyList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "TagKeyList":
            return Optional.ofNullable(clazz.cast(tagKeyList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("TagKeyList", TAG_KEY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UntagStreamRequest, T> g) {
        return obj -> g.apply((UntagStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo, CopyableBuilder<Builder, UntagStreamRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream that you want to remove tags from.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream that you want to remove tags from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The name of the stream that you want to remove tags from.
         * </p>
         * 
         * @param streamName
         *        The name of the stream that you want to remove tags from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * A list of the keys of the tags that you want to remove.
         * </p>
         * 
         * @param tagKeyList
         *        A list of the keys of the tags that you want to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeyList(Collection<String> tagKeyList);

        /**
         * <p>
         * A list of the keys of the tags that you want to remove.
         * </p>
         * 
         * @param tagKeyList
         *        A list of the keys of the tags that you want to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeyList(String... tagKeyList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String streamARN;

        private String streamName;

        private List<String> tagKeyList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UntagStreamRequest model) {
            super(model);
            streamARN(model.streamARN);
            streamName(model.streamName);
            tagKeyList(model.tagKeyList);
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final Collection<String> getTagKeyList() {
            if (tagKeyList instanceof SdkAutoConstructList) {
                return null;
            }
            return tagKeyList;
        }

        public final void setTagKeyList(Collection<String> tagKeyList) {
            this.tagKeyList = TagKeyListCopier.copy(tagKeyList);
        }

        @Override
        public final Builder tagKeyList(Collection<String> tagKeyList) {
            this.tagKeyList = TagKeyListCopier.copy(tagKeyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeyList(String... tagKeyList) {
            tagKeyList(Arrays.asList(tagKeyList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UntagStreamRequest build() {
            return new UntagStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
