/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for stream storage, including the default storage tier for stream data. This configuration
 * determines how stream data is stored and accessed, with different tiers offering varying levels of performance and
 * cost optimization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamStorageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamStorageConfiguration.Builder, StreamStorageConfiguration> {
    private static final SdkField<String> DEFAULT_STORAGE_TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultStorageTier").getter(getter(StreamStorageConfiguration::defaultStorageTierAsString))
            .setter(setter(Builder::defaultStorageTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultStorageTier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_STORAGE_TIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String defaultStorageTier;

    private StreamStorageConfiguration(BuilderImpl builder) {
        this.defaultStorageTier = builder.defaultStorageTier;
    }

    /**
     * <p>
     * The default storage tier for the stream data. This setting determines the storage class used for stream data,
     * affecting both performance characteristics and storage costs.
     * </p>
     * <p>
     * Available storage tiers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HOT</code> - Optimized for frequent access with the lowest latency and highest performance. Ideal for
     * real-time applications and frequently accessed data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARM</code> - Balanced performance and cost for moderately accessed data. Suitable for data that is
     * accessed regularly but not continuously.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultStorageTier} will return {@link DefaultStorageTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #defaultStorageTierAsString}.
     * </p>
     * 
     * @return The default storage tier for the stream data. This setting determines the storage class used for stream
     *         data, affecting both performance characteristics and storage costs.</p>
     *         <p>
     *         Available storage tiers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HOT</code> - Optimized for frequent access with the lowest latency and highest performance. Ideal
     *         for real-time applications and frequently accessed data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARM</code> - Balanced performance and cost for moderately accessed data. Suitable for data that is
     *         accessed regularly but not continuously.
     *         </p>
     *         </li>
     * @see DefaultStorageTier
     */
    public final DefaultStorageTier defaultStorageTier() {
        return DefaultStorageTier.fromValue(defaultStorageTier);
    }

    /**
     * <p>
     * The default storage tier for the stream data. This setting determines the storage class used for stream data,
     * affecting both performance characteristics and storage costs.
     * </p>
     * <p>
     * Available storage tiers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HOT</code> - Optimized for frequent access with the lowest latency and highest performance. Ideal for
     * real-time applications and frequently accessed data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARM</code> - Balanced performance and cost for moderately accessed data. Suitable for data that is
     * accessed regularly but not continuously.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultStorageTier} will return {@link DefaultStorageTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #defaultStorageTierAsString}.
     * </p>
     * 
     * @return The default storage tier for the stream data. This setting determines the storage class used for stream
     *         data, affecting both performance characteristics and storage costs.</p>
     *         <p>
     *         Available storage tiers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HOT</code> - Optimized for frequent access with the lowest latency and highest performance. Ideal
     *         for real-time applications and frequently accessed data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARM</code> - Balanced performance and cost for moderately accessed data. Suitable for data that is
     *         accessed regularly but not continuously.
     *         </p>
     *         </li>
     * @see DefaultStorageTier
     */
    public final String defaultStorageTierAsString() {
        return defaultStorageTier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultStorageTierAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamStorageConfiguration)) {
            return false;
        }
        StreamStorageConfiguration other = (StreamStorageConfiguration) obj;
        return Objects.equals(defaultStorageTierAsString(), other.defaultStorageTierAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamStorageConfiguration").add("DefaultStorageTier", defaultStorageTierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultStorageTier":
            return Optional.ofNullable(clazz.cast(defaultStorageTierAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultStorageTier", DEFAULT_STORAGE_TIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamStorageConfiguration, T> g) {
        return obj -> g.apply((StreamStorageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamStorageConfiguration> {
        /**
         * <p>
         * The default storage tier for the stream data. This setting determines the storage class used for stream data,
         * affecting both performance characteristics and storage costs.
         * </p>
         * <p>
         * Available storage tiers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HOT</code> - Optimized for frequent access with the lowest latency and highest performance. Ideal for
         * real-time applications and frequently accessed data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARM</code> - Balanced performance and cost for moderately accessed data. Suitable for data that is
         * accessed regularly but not continuously.
         * </p>
         * </li>
         * </ul>
         * 
         * @param defaultStorageTier
         *        The default storage tier for the stream data. This setting determines the storage class used for
         *        stream data, affecting both performance characteristics and storage costs.</p>
         *        <p>
         *        Available storage tiers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HOT</code> - Optimized for frequent access with the lowest latency and highest performance.
         *        Ideal for real-time applications and frequently accessed data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARM</code> - Balanced performance and cost for moderately accessed data. Suitable for data that
         *        is accessed regularly but not continuously.
         *        </p>
         *        </li>
         * @see DefaultStorageTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultStorageTier
         */
        Builder defaultStorageTier(String defaultStorageTier);

        /**
         * <p>
         * The default storage tier for the stream data. This setting determines the storage class used for stream data,
         * affecting both performance characteristics and storage costs.
         * </p>
         * <p>
         * Available storage tiers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HOT</code> - Optimized for frequent access with the lowest latency and highest performance. Ideal for
         * real-time applications and frequently accessed data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARM</code> - Balanced performance and cost for moderately accessed data. Suitable for data that is
         * accessed regularly but not continuously.
         * </p>
         * </li>
         * </ul>
         * 
         * @param defaultStorageTier
         *        The default storage tier for the stream data. This setting determines the storage class used for
         *        stream data, affecting both performance characteristics and storage costs.</p>
         *        <p>
         *        Available storage tiers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HOT</code> - Optimized for frequent access with the lowest latency and highest performance.
         *        Ideal for real-time applications and frequently accessed data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARM</code> - Balanced performance and cost for moderately accessed data. Suitable for data that
         *        is accessed regularly but not continuously.
         *        </p>
         *        </li>
         * @see DefaultStorageTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultStorageTier
         */
        Builder defaultStorageTier(DefaultStorageTier defaultStorageTier);
    }

    static final class BuilderImpl implements Builder {
        private String defaultStorageTier;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamStorageConfiguration model) {
            defaultStorageTier(model.defaultStorageTier);
        }

        public final String getDefaultStorageTier() {
            return defaultStorageTier;
        }

        public final void setDefaultStorageTier(String defaultStorageTier) {
            this.defaultStorageTier = defaultStorageTier;
        }

        @Override
        public final Builder defaultStorageTier(String defaultStorageTier) {
            this.defaultStorageTier = defaultStorageTier;
            return this;
        }

        @Override
        public final Builder defaultStorageTier(DefaultStorageTier defaultStorageTier) {
            this.defaultStorageTier(defaultStorageTier == null ? null : defaultStorageTier.toString());
            return this;
        }

        @Override
        public StreamStorageConfiguration build() {
            return new StreamStorageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
