/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartEdgeConfigurationUpdateResponse extends KinesisVideoResponse implements
        ToCopyableBuilder<StartEdgeConfigurationUpdateResponse.Builder, StartEdgeConfigurationUpdateResponse> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(StartEdgeConfigurationUpdateResponse::streamName))
            .setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(StartEdgeConfigurationUpdateResponse::streamARN))
            .setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(StartEdgeConfigurationUpdateResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(StartEdgeConfigurationUpdateResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> SYNC_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncStatus").getter(getter(StartEdgeConfigurationUpdateResponse::syncStatusAsString))
            .setter(setter(Builder::syncStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncStatus").build()).build();

    private static final SdkField<String> FAILED_STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailedStatusDetails").getter(getter(StartEdgeConfigurationUpdateResponse::failedStatusDetails))
            .setter(setter(Builder::failedStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedStatusDetails").build())
            .build();

    private static final SdkField<EdgeConfig> EDGE_CONFIG_FIELD = SdkField.<EdgeConfig> builder(MarshallingType.SDK_POJO)
            .memberName("EdgeConfig").getter(getter(StartEdgeConfigurationUpdateResponse::edgeConfig))
            .setter(setter(Builder::edgeConfig)).constructor(EdgeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            STREAM_ARN_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, SYNC_STATUS_FIELD, FAILED_STATUS_DETAILS_FIELD,
            EDGE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamName;

    private final String streamARN;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private final String syncStatus;

    private final String failedStatusDetails;

    private final EdgeConfig edgeConfig;

    private StartEdgeConfigurationUpdateResponse(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.syncStatus = builder.syncStatus;
        this.failedStatusDetails = builder.failedStatusDetails;
        this.edgeConfig = builder.edgeConfig;
    }

    /**
     * <p>
     * The name of the stream from which the edge configuration was updated.
     * </p>
     * 
     * @return The name of the stream from which the edge configuration was updated.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The timestamp at which a stream’s edge configuration was first created.
     * </p>
     * 
     * @return The timestamp at which a stream’s edge configuration was first created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The timestamp at which a stream’s edge configuration was last updated.
     * </p>
     * 
     * @return The timestamp at which a stream’s edge configuration was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The current sync status of the stream's edge configuration. When you invoke this API, the sync status will be set
     * to the <code>SYNCING</code> state. Use the <code>DescribeEdgeConfiguration</code> API to get the latest status of
     * the edge configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncStatus} will
     * return {@link SyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #syncStatusAsString}.
     * </p>
     * 
     * @return The current sync status of the stream's edge configuration. When you invoke this API, the sync status
     *         will be set to the <code>SYNCING</code> state. Use the <code>DescribeEdgeConfiguration</code> API to get
     *         the latest status of the edge configuration.
     * @see SyncStatus
     */
    public final SyncStatus syncStatus() {
        return SyncStatus.fromValue(syncStatus);
    }

    /**
     * <p>
     * The current sync status of the stream's edge configuration. When you invoke this API, the sync status will be set
     * to the <code>SYNCING</code> state. Use the <code>DescribeEdgeConfiguration</code> API to get the latest status of
     * the edge configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncStatus} will
     * return {@link SyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #syncStatusAsString}.
     * </p>
     * 
     * @return The current sync status of the stream's edge configuration. When you invoke this API, the sync status
     *         will be set to the <code>SYNCING</code> state. Use the <code>DescribeEdgeConfiguration</code> API to get
     *         the latest status of the edge configuration.
     * @see SyncStatus
     */
    public final String syncStatusAsString() {
        return syncStatus;
    }

    /**
     * <p>
     * A description of the generated failure status.
     * </p>
     * 
     * @return A description of the generated failure status.
     */
    public final String failedStatusDetails() {
        return failedStatusDetails;
    }

    /**
     * <p>
     * A description of the stream's edge configuration that will be used to sync with the Edge Agent IoT Greengrass
     * component. The Edge Agent component will run on an IoT Hub Device setup at your premise.
     * </p>
     * 
     * @return A description of the stream's edge configuration that will be used to sync with the Edge Agent IoT
     *         Greengrass component. The Edge Agent component will run on an IoT Hub Device setup at your premise.
     */
    public final EdgeConfig edgeConfig() {
        return edgeConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(syncStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failedStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(edgeConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartEdgeConfigurationUpdateResponse)) {
            return false;
        }
        StartEdgeConfigurationUpdateResponse other = (StartEdgeConfigurationUpdateResponse) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(streamARN(), other.streamARN())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(syncStatusAsString(), other.syncStatusAsString())
                && Objects.equals(failedStatusDetails(), other.failedStatusDetails())
                && Objects.equals(edgeConfig(), other.edgeConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartEdgeConfigurationUpdateResponse").add("StreamName", streamName())
                .add("StreamARN", streamARN()).add("CreationTime", creationTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("SyncStatus", syncStatusAsString()).add("FailedStatusDetails", failedStatusDetails())
                .add("EdgeConfig", edgeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "SyncStatus":
            return Optional.ofNullable(clazz.cast(syncStatusAsString()));
        case "FailedStatusDetails":
            return Optional.ofNullable(clazz.cast(failedStatusDetails()));
        case "EdgeConfig":
            return Optional.ofNullable(clazz.cast(edgeConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("SyncStatus", SYNC_STATUS_FIELD);
        map.put("FailedStatusDetails", FAILED_STATUS_DETAILS_FIELD);
        map.put("EdgeConfig", EDGE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartEdgeConfigurationUpdateResponse, T> g) {
        return obj -> g.apply((StartEdgeConfigurationUpdateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisVideoResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartEdgeConfigurationUpdateResponse> {
        /**
         * <p>
         * The name of the stream from which the edge configuration was updated.
         * </p>
         * 
         * @param streamName
         *        The name of the stream from which the edge configuration was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The timestamp at which a stream’s edge configuration was first created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp at which a stream’s edge configuration was first created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The timestamp at which a stream’s edge configuration was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp at which a stream’s edge configuration was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The current sync status of the stream's edge configuration. When you invoke this API, the sync status will be
         * set to the <code>SYNCING</code> state. Use the <code>DescribeEdgeConfiguration</code> API to get the latest
         * status of the edge configuration.
         * </p>
         * 
         * @param syncStatus
         *        The current sync status of the stream's edge configuration. When you invoke this API, the sync status
         *        will be set to the <code>SYNCING</code> state. Use the <code>DescribeEdgeConfiguration</code> API to
         *        get the latest status of the edge configuration.
         * @see SyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncStatus
         */
        Builder syncStatus(String syncStatus);

        /**
         * <p>
         * The current sync status of the stream's edge configuration. When you invoke this API, the sync status will be
         * set to the <code>SYNCING</code> state. Use the <code>DescribeEdgeConfiguration</code> API to get the latest
         * status of the edge configuration.
         * </p>
         * 
         * @param syncStatus
         *        The current sync status of the stream's edge configuration. When you invoke this API, the sync status
         *        will be set to the <code>SYNCING</code> state. Use the <code>DescribeEdgeConfiguration</code> API to
         *        get the latest status of the edge configuration.
         * @see SyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncStatus
         */
        Builder syncStatus(SyncStatus syncStatus);

        /**
         * <p>
         * A description of the generated failure status.
         * </p>
         * 
         * @param failedStatusDetails
         *        A description of the generated failure status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedStatusDetails(String failedStatusDetails);

        /**
         * <p>
         * A description of the stream's edge configuration that will be used to sync with the Edge Agent IoT Greengrass
         * component. The Edge Agent component will run on an IoT Hub Device setup at your premise.
         * </p>
         * 
         * @param edgeConfig
         *        A description of the stream's edge configuration that will be used to sync with the Edge Agent IoT
         *        Greengrass component. The Edge Agent component will run on an IoT Hub Device setup at your premise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeConfig(EdgeConfig edgeConfig);

        /**
         * <p>
         * A description of the stream's edge configuration that will be used to sync with the Edge Agent IoT Greengrass
         * component. The Edge Agent component will run on an IoT Hub Device setup at your premise.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdgeConfig.Builder} avoiding the need to
         * create one manually via {@link EdgeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdgeConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #edgeConfig(EdgeConfig)}.
         * 
         * @param edgeConfig
         *        a consumer that will call methods on {@link EdgeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #edgeConfig(EdgeConfig)
         */
        default Builder edgeConfig(Consumer<EdgeConfig.Builder> edgeConfig) {
            return edgeConfig(EdgeConfig.builder().applyMutation(edgeConfig).build());
        }
    }

    static final class BuilderImpl extends KinesisVideoResponse.BuilderImpl implements Builder {
        private String streamName;

        private String streamARN;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private String syncStatus;

        private String failedStatusDetails;

        private EdgeConfig edgeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StartEdgeConfigurationUpdateResponse model) {
            super(model);
            streamName(model.streamName);
            streamARN(model.streamARN);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            syncStatus(model.syncStatus);
            failedStatusDetails(model.failedStatusDetails);
            edgeConfig(model.edgeConfig);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getSyncStatus() {
            return syncStatus;
        }

        public final void setSyncStatus(String syncStatus) {
            this.syncStatus = syncStatus;
        }

        @Override
        public final Builder syncStatus(String syncStatus) {
            this.syncStatus = syncStatus;
            return this;
        }

        @Override
        public final Builder syncStatus(SyncStatus syncStatus) {
            this.syncStatus(syncStatus == null ? null : syncStatus.toString());
            return this;
        }

        public final String getFailedStatusDetails() {
            return failedStatusDetails;
        }

        public final void setFailedStatusDetails(String failedStatusDetails) {
            this.failedStatusDetails = failedStatusDetails;
        }

        @Override
        public final Builder failedStatusDetails(String failedStatusDetails) {
            this.failedStatusDetails = failedStatusDetails;
            return this;
        }

        public final EdgeConfig.Builder getEdgeConfig() {
            return edgeConfig != null ? edgeConfig.toBuilder() : null;
        }

        public final void setEdgeConfig(EdgeConfig.BuilderImpl edgeConfig) {
            this.edgeConfig = edgeConfig != null ? edgeConfig.build() : null;
        }

        @Override
        public final Builder edgeConfig(EdgeConfig edgeConfig) {
            this.edgeConfig = edgeConfig;
            return this;
        }

        @Override
        public StartEdgeConfigurationUpdateResponse build() {
            return new StartEdgeConfigurationUpdateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
