/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This API enables you to specify the duration that the camera, or local media file, should record onto the Edge Agent.
 * The <code>ScheduleConfig</code> consists of the <code>ScheduleExpression</code> and the
 * <code>DurationInMinutes</code> attributes.
 * </p>
 * <p>
 * If the <code>ScheduleConfig</code> is not provided in the <code>RecorderConfig</code>, then the Edge Agent will
 * always be set to recording mode.
 * </p>
 * <p>
 * If the <code>ScheduleConfig</code> is not provided in the <code>UploaderConfig</code>, then the Edge Agent will
 * upload at regular intervals (every 1 hour).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleConfig implements SdkPojo, Serializable, ToCopyableBuilder<ScheduleConfig.Builder, ScheduleConfig> {
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(ScheduleConfig::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationInSeconds").getter(getter(ScheduleConfig::durationInSeconds))
            .setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_EXPRESSION_FIELD,
            DURATION_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scheduleExpression;

    private final Integer durationInSeconds;

    private ScheduleConfig(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
        this.durationInSeconds = builder.durationInSeconds;
    }

    /**
     * <p>
     * The Quartz cron expression that takes care of scheduling jobs to record from the camera, or local media file,
     * onto the Edge Agent. If the <code>ScheduleExpression</code> is not provided for the <code>RecorderConfig</code>,
     * then the Edge Agent will always be set to recording mode.
     * </p>
     * <p>
     * For more information about Quartz, refer to the <a
     * href="https://www.quartz-scheduler.org/documentation/quartz-2.3.0/tutorials/crontrigger.html"> <i>Cron Trigger
     * Tutorial</i> </a> page to understand the valid expressions and its use.
     * </p>
     * 
     * @return The Quartz cron expression that takes care of scheduling jobs to record from the camera, or local media
     *         file, onto the Edge Agent. If the <code>ScheduleExpression</code> is not provided for the
     *         <code>RecorderConfig</code>, then the Edge Agent will always be set to recording mode.</p>
     *         <p>
     *         For more information about Quartz, refer to the <a
     *         href="https://www.quartz-scheduler.org/documentation/quartz-2.3.0/tutorials/crontrigger.html"> <i>Cron
     *         Trigger Tutorial</i> </a> page to understand the valid expressions and its use.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * The total duration to record the media. If the <code>ScheduleExpression</code> attribute is provided, then the
     * <code>DurationInSeconds</code> attribute should also be specified.
     * </p>
     * 
     * @return The total duration to record the media. If the <code>ScheduleExpression</code> attribute is provided,
     *         then the <code>DurationInSeconds</code> attribute should also be specified.
     */
    public final Integer durationInSeconds() {
        return durationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleConfig)) {
            return false;
        }
        ScheduleConfig other = (ScheduleConfig) obj;
        return Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(durationInSeconds(), other.durationInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleConfig").add("ScheduleExpression", scheduleExpression())
                .add("DurationInSeconds", durationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "DurationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduleConfig, T> g) {
        return obj -> g.apply((ScheduleConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleConfig> {
        /**
         * <p>
         * The Quartz cron expression that takes care of scheduling jobs to record from the camera, or local media file,
         * onto the Edge Agent. If the <code>ScheduleExpression</code> is not provided for the
         * <code>RecorderConfig</code>, then the Edge Agent will always be set to recording mode.
         * </p>
         * <p>
         * For more information about Quartz, refer to the <a
         * href="https://www.quartz-scheduler.org/documentation/quartz-2.3.0/tutorials/crontrigger.html"> <i>Cron
         * Trigger Tutorial</i> </a> page to understand the valid expressions and its use.
         * </p>
         * 
         * @param scheduleExpression
         *        The Quartz cron expression that takes care of scheduling jobs to record from the camera, or local
         *        media file, onto the Edge Agent. If the <code>ScheduleExpression</code> is not provided for the
         *        <code>RecorderConfig</code>, then the Edge Agent will always be set to recording mode.</p>
         *        <p>
         *        For more information about Quartz, refer to the <a
         *        href="https://www.quartz-scheduler.org/documentation/quartz-2.3.0/tutorials/crontrigger.html"> <i>Cron
         *        Trigger Tutorial</i> </a> page to understand the valid expressions and its use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * The total duration to record the media. If the <code>ScheduleExpression</code> attribute is provided, then
         * the <code>DurationInSeconds</code> attribute should also be specified.
         * </p>
         * 
         * @param durationInSeconds
         *        The total duration to record the media. If the <code>ScheduleExpression</code> attribute is provided,
         *        then the <code>DurationInSeconds</code> attribute should also be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String scheduleExpression;

        private Integer durationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleConfig model) {
            scheduleExpression(model.scheduleExpression);
            durationInSeconds(model.durationInSeconds);
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        @Override
        public ScheduleConfig build() {
            return new ScheduleConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
