/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The latest status of a stream’s edge to cloud uploader job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LastUploaderStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<LastUploaderStatus.Builder, LastUploaderStatus> {
    private static final SdkField<String> JOB_STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatusDetails").getter(getter(LastUploaderStatus::jobStatusDetails))
            .setter(setter(Builder::jobStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatusDetails").build()).build();

    private static final SdkField<Instant> LAST_COLLECTED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastCollectedTime").getter(getter(LastUploaderStatus::lastCollectedTime))
            .setter(setter(Builder::lastCollectedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastCollectedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(LastUploaderStatus::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> UPLOADER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UploaderStatus").getter(getter(LastUploaderStatus::uploaderStatusAsString))
            .setter(setter(Builder::uploaderStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploaderStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_DETAILS_FIELD,
            LAST_COLLECTED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, UPLOADER_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobStatusDetails;

    private final Instant lastCollectedTime;

    private final Instant lastUpdatedTime;

    private final String uploaderStatus;

    private LastUploaderStatus(BuilderImpl builder) {
        this.jobStatusDetails = builder.jobStatusDetails;
        this.lastCollectedTime = builder.lastCollectedTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.uploaderStatus = builder.uploaderStatus;
    }

    /**
     * <p>
     * A description of an uploader job’s latest status.
     * </p>
     * 
     * @return A description of an uploader job’s latest status.
     */
    public final String jobStatusDetails() {
        return jobStatusDetails;
    }

    /**
     * <p>
     * The timestamp at which the uploader job was last executed and media collected to the cloud.
     * </p>
     * 
     * @return The timestamp at which the uploader job was last executed and media collected to the cloud.
     */
    public final Instant lastCollectedTime() {
        return lastCollectedTime;
    }

    /**
     * <p>
     * The timestamp at which the uploader status was last updated.
     * </p>
     * 
     * @return The timestamp at which the uploader status was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The status of the latest uploader job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploaderStatus}
     * will return {@link UploaderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #uploaderStatusAsString}.
     * </p>
     * 
     * @return The status of the latest uploader job.
     * @see UploaderStatus
     */
    public final UploaderStatus uploaderStatus() {
        return UploaderStatus.fromValue(uploaderStatus);
    }

    /**
     * <p>
     * The status of the latest uploader job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploaderStatus}
     * will return {@link UploaderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #uploaderStatusAsString}.
     * </p>
     * 
     * @return The status of the latest uploader job.
     * @see UploaderStatus
     */
    public final String uploaderStatusAsString() {
        return uploaderStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(lastCollectedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(uploaderStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastUploaderStatus)) {
            return false;
        }
        LastUploaderStatus other = (LastUploaderStatus) obj;
        return Objects.equals(jobStatusDetails(), other.jobStatusDetails())
                && Objects.equals(lastCollectedTime(), other.lastCollectedTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(uploaderStatusAsString(), other.uploaderStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LastUploaderStatus").add("JobStatusDetails", jobStatusDetails())
                .add("LastCollectedTime", lastCollectedTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("UploaderStatus", uploaderStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatusDetails":
            return Optional.ofNullable(clazz.cast(jobStatusDetails()));
        case "LastCollectedTime":
            return Optional.ofNullable(clazz.cast(lastCollectedTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "UploaderStatus":
            return Optional.ofNullable(clazz.cast(uploaderStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobStatusDetails", JOB_STATUS_DETAILS_FIELD);
        map.put("LastCollectedTime", LAST_COLLECTED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("UploaderStatus", UPLOADER_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LastUploaderStatus, T> g) {
        return obj -> g.apply((LastUploaderStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LastUploaderStatus> {
        /**
         * <p>
         * A description of an uploader job’s latest status.
         * </p>
         * 
         * @param jobStatusDetails
         *        A description of an uploader job’s latest status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobStatusDetails(String jobStatusDetails);

        /**
         * <p>
         * The timestamp at which the uploader job was last executed and media collected to the cloud.
         * </p>
         * 
         * @param lastCollectedTime
         *        The timestamp at which the uploader job was last executed and media collected to the cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastCollectedTime(Instant lastCollectedTime);

        /**
         * <p>
         * The timestamp at which the uploader status was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp at which the uploader status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The status of the latest uploader job.
         * </p>
         * 
         * @param uploaderStatus
         *        The status of the latest uploader job.
         * @see UploaderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploaderStatus
         */
        Builder uploaderStatus(String uploaderStatus);

        /**
         * <p>
         * The status of the latest uploader job.
         * </p>
         * 
         * @param uploaderStatus
         *        The status of the latest uploader job.
         * @see UploaderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploaderStatus
         */
        Builder uploaderStatus(UploaderStatus uploaderStatus);
    }

    static final class BuilderImpl implements Builder {
        private String jobStatusDetails;

        private Instant lastCollectedTime;

        private Instant lastUpdatedTime;

        private String uploaderStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LastUploaderStatus model) {
            jobStatusDetails(model.jobStatusDetails);
            lastCollectedTime(model.lastCollectedTime);
            lastUpdatedTime(model.lastUpdatedTime);
            uploaderStatus(model.uploaderStatus);
        }

        public final String getJobStatusDetails() {
            return jobStatusDetails;
        }

        public final void setJobStatusDetails(String jobStatusDetails) {
            this.jobStatusDetails = jobStatusDetails;
        }

        @Override
        public final Builder jobStatusDetails(String jobStatusDetails) {
            this.jobStatusDetails = jobStatusDetails;
            return this;
        }

        public final Instant getLastCollectedTime() {
            return lastCollectedTime;
        }

        public final void setLastCollectedTime(Instant lastCollectedTime) {
            this.lastCollectedTime = lastCollectedTime;
        }

        @Override
        public final Builder lastCollectedTime(Instant lastCollectedTime) {
            this.lastCollectedTime = lastCollectedTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getUploaderStatus() {
            return uploaderStatus;
        }

        public final void setUploaderStatus(String uploaderStatus) {
            this.uploaderStatus = uploaderStatus;
        }

        @Override
        public final Builder uploaderStatus(String uploaderStatus) {
            this.uploaderStatus = uploaderStatus;
            return this;
        }

        @Override
        public final Builder uploaderStatus(UploaderStatus uploaderStatus) {
            this.uploaderStatus(uploaderStatus == null ? null : uploaderStatus.toString());
            return this;
        }

        @Override
        public LastUploaderStatus build() {
            return new LastUploaderStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
