/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details required to delete the connection of the stream from the Edge Agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletionConfig implements SdkPojo, Serializable, ToCopyableBuilder<DeletionConfig.Builder, DeletionConfig> {
    private static final SdkField<Integer> EDGE_RETENTION_IN_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EdgeRetentionInHours").getter(getter(DeletionConfig::edgeRetentionInHours))
            .setter(setter(Builder::edgeRetentionInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeRetentionInHours").build())
            .build();

    private static final SdkField<LocalSizeConfig> LOCAL_SIZE_CONFIG_FIELD = SdkField
            .<LocalSizeConfig> builder(MarshallingType.SDK_POJO).memberName("LocalSizeConfig")
            .getter(getter(DeletionConfig::localSizeConfig)).setter(setter(Builder::localSizeConfig))
            .constructor(LocalSizeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSizeConfig").build()).build();

    private static final SdkField<Boolean> DELETE_AFTER_UPLOAD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteAfterUpload").getter(getter(DeletionConfig::deleteAfterUpload))
            .setter(setter(Builder::deleteAfterUpload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteAfterUpload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_RETENTION_IN_HOURS_FIELD,
            LOCAL_SIZE_CONFIG_FIELD, DELETE_AFTER_UPLOAD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer edgeRetentionInHours;

    private final LocalSizeConfig localSizeConfig;

    private final Boolean deleteAfterUpload;

    private DeletionConfig(BuilderImpl builder) {
        this.edgeRetentionInHours = builder.edgeRetentionInHours;
        this.localSizeConfig = builder.localSizeConfig;
        this.deleteAfterUpload = builder.deleteAfterUpload;
    }

    /**
     * <p>
     * The number of hours that you want to retain the data in the stream on the Edge Agent. The default value of the
     * retention time is 720 hours, which translates to 30 days.
     * </p>
     * 
     * @return The number of hours that you want to retain the data in the stream on the Edge Agent. The default value
     *         of the retention time is 720 hours, which translates to 30 days.
     */
    public final Integer edgeRetentionInHours() {
        return edgeRetentionInHours;
    }

    /**
     * <p>
     * The value of the local size required in order to delete the edge configuration.
     * </p>
     * 
     * @return The value of the local size required in order to delete the edge configuration.
     */
    public final LocalSizeConfig localSizeConfig() {
        return localSizeConfig;
    }

    /**
     * <p>
     * The <code>boolean</code> value used to indicate whether or not you want to mark the media for deletion, once it
     * has been uploaded to the Kinesis Video Stream cloud. The media files can be deleted if any of the deletion
     * configuration values are set to <code>true</code>, such as when the limit for the
     * <code>EdgeRetentionInHours</code>, or the <code>MaxLocalMediaSizeInMB</code>, has been reached.
     * </p>
     * <p>
     * Since the default value is set to <code>true</code>, configure the uploader schedule such that the media files
     * are not being deleted before they are initially uploaded to the Amazon Web Services cloud.
     * </p>
     * 
     * @return The <code>boolean</code> value used to indicate whether or not you want to mark the media for deletion,
     *         once it has been uploaded to the Kinesis Video Stream cloud. The media files can be deleted if any of the
     *         deletion configuration values are set to <code>true</code>, such as when the limit for the
     *         <code>EdgeRetentionInHours</code>, or the <code>MaxLocalMediaSizeInMB</code>, has been reached. </p>
     *         <p>
     *         Since the default value is set to <code>true</code>, configure the uploader schedule such that the media
     *         files are not being deleted before they are initially uploaded to the Amazon Web Services cloud.
     */
    public final Boolean deleteAfterUpload() {
        return deleteAfterUpload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(edgeRetentionInHours());
        hashCode = 31 * hashCode + Objects.hashCode(localSizeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(deleteAfterUpload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletionConfig)) {
            return false;
        }
        DeletionConfig other = (DeletionConfig) obj;
        return Objects.equals(edgeRetentionInHours(), other.edgeRetentionInHours())
                && Objects.equals(localSizeConfig(), other.localSizeConfig())
                && Objects.equals(deleteAfterUpload(), other.deleteAfterUpload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletionConfig").add("EdgeRetentionInHours", edgeRetentionInHours())
                .add("LocalSizeConfig", localSizeConfig()).add("DeleteAfterUpload", deleteAfterUpload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EdgeRetentionInHours":
            return Optional.ofNullable(clazz.cast(edgeRetentionInHours()));
        case "LocalSizeConfig":
            return Optional.ofNullable(clazz.cast(localSizeConfig()));
        case "DeleteAfterUpload":
            return Optional.ofNullable(clazz.cast(deleteAfterUpload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EdgeRetentionInHours", EDGE_RETENTION_IN_HOURS_FIELD);
        map.put("LocalSizeConfig", LOCAL_SIZE_CONFIG_FIELD);
        map.put("DeleteAfterUpload", DELETE_AFTER_UPLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeletionConfig, T> g) {
        return obj -> g.apply((DeletionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeletionConfig> {
        /**
         * <p>
         * The number of hours that you want to retain the data in the stream on the Edge Agent. The default value of
         * the retention time is 720 hours, which translates to 30 days.
         * </p>
         * 
         * @param edgeRetentionInHours
         *        The number of hours that you want to retain the data in the stream on the Edge Agent. The default
         *        value of the retention time is 720 hours, which translates to 30 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeRetentionInHours(Integer edgeRetentionInHours);

        /**
         * <p>
         * The value of the local size required in order to delete the edge configuration.
         * </p>
         * 
         * @param localSizeConfig
         *        The value of the local size required in order to delete the edge configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSizeConfig(LocalSizeConfig localSizeConfig);

        /**
         * <p>
         * The value of the local size required in order to delete the edge configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LocalSizeConfig.Builder} avoiding the
         * need to create one manually via {@link LocalSizeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LocalSizeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #localSizeConfig(LocalSizeConfig)}.
         * 
         * @param localSizeConfig
         *        a consumer that will call methods on {@link LocalSizeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localSizeConfig(LocalSizeConfig)
         */
        default Builder localSizeConfig(Consumer<LocalSizeConfig.Builder> localSizeConfig) {
            return localSizeConfig(LocalSizeConfig.builder().applyMutation(localSizeConfig).build());
        }

        /**
         * <p>
         * The <code>boolean</code> value used to indicate whether or not you want to mark the media for deletion, once
         * it has been uploaded to the Kinesis Video Stream cloud. The media files can be deleted if any of the deletion
         * configuration values are set to <code>true</code>, such as when the limit for the
         * <code>EdgeRetentionInHours</code>, or the <code>MaxLocalMediaSizeInMB</code>, has been reached.
         * </p>
         * <p>
         * Since the default value is set to <code>true</code>, configure the uploader schedule such that the media
         * files are not being deleted before they are initially uploaded to the Amazon Web Services cloud.
         * </p>
         * 
         * @param deleteAfterUpload
         *        The <code>boolean</code> value used to indicate whether or not you want to mark the media for
         *        deletion, once it has been uploaded to the Kinesis Video Stream cloud. The media files can be deleted
         *        if any of the deletion configuration values are set to <code>true</code>, such as when the limit for
         *        the <code>EdgeRetentionInHours</code>, or the <code>MaxLocalMediaSizeInMB</code>, has been reached.
         *        </p>
         *        <p>
         *        Since the default value is set to <code>true</code>, configure the uploader schedule such that the
         *        media files are not being deleted before they are initially uploaded to the Amazon Web Services cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAfterUpload(Boolean deleteAfterUpload);
    }

    static final class BuilderImpl implements Builder {
        private Integer edgeRetentionInHours;

        private LocalSizeConfig localSizeConfig;

        private Boolean deleteAfterUpload;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletionConfig model) {
            edgeRetentionInHours(model.edgeRetentionInHours);
            localSizeConfig(model.localSizeConfig);
            deleteAfterUpload(model.deleteAfterUpload);
        }

        public final Integer getEdgeRetentionInHours() {
            return edgeRetentionInHours;
        }

        public final void setEdgeRetentionInHours(Integer edgeRetentionInHours) {
            this.edgeRetentionInHours = edgeRetentionInHours;
        }

        @Override
        public final Builder edgeRetentionInHours(Integer edgeRetentionInHours) {
            this.edgeRetentionInHours = edgeRetentionInHours;
            return this;
        }

        public final LocalSizeConfig.Builder getLocalSizeConfig() {
            return localSizeConfig != null ? localSizeConfig.toBuilder() : null;
        }

        public final void setLocalSizeConfig(LocalSizeConfig.BuilderImpl localSizeConfig) {
            this.localSizeConfig = localSizeConfig != null ? localSizeConfig.build() : null;
        }

        @Override
        public final Builder localSizeConfig(LocalSizeConfig localSizeConfig) {
            this.localSizeConfig = localSizeConfig;
            return this;
        }

        public final Boolean getDeleteAfterUpload() {
            return deleteAfterUpload;
        }

        public final void setDeleteAfterUpload(Boolean deleteAfterUpload) {
            this.deleteAfterUpload = deleteAfterUpload;
        }

        @Override
        public final Builder deleteAfterUpload(Boolean deleteAfterUpload) {
            this.deleteAfterUpload = deleteAfterUpload;
            return this;
        }

        @Override
        public DeletionConfig build() {
            return new DeletionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
