/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoResponse;
import software.amazon.awssdk.services.kinesisvideo.model.MappedResourceConfigurationListCopier;
import software.amazon.awssdk.services.kinesisvideo.model.MappedResourceConfigurationListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMappedResourceConfigurationResponse
extends KinesisVideoResponse
implements ToCopyableBuilder<Builder, DescribeMappedResourceConfigurationResponse> {
    private static final SdkField<List<MappedResourceConfigurationListItem>> MAPPED_RESOURCE_CONFIGURATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MappedResourceConfigurationList").getter(DescribeMappedResourceConfigurationResponse.getter(DescribeMappedResourceConfigurationResponse::mappedResourceConfigurationList)).setter(DescribeMappedResourceConfigurationResponse.setter(Builder::mappedResourceConfigurationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MappedResourceConfigurationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MappedResourceConfigurationListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMappedResourceConfigurationResponse.getter(DescribeMappedResourceConfigurationResponse::nextToken)).setter(DescribeMappedResourceConfigurationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAPPED_RESOURCE_CONFIGURATION_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMappedResourceConfigurationResponse.memberNameToFieldInitializer();
    private final List<MappedResourceConfigurationListItem> mappedResourceConfigurationList;
    private final String nextToken;

    private DescribeMappedResourceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.mappedResourceConfigurationList = builder.mappedResourceConfigurationList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMappedResourceConfigurationList() {
        return this.mappedResourceConfigurationList != null && !(this.mappedResourceConfigurationList instanceof SdkAutoConstructList);
    }

    public final List<MappedResourceConfigurationListItem> mappedResourceConfigurationList() {
        return this.mappedResourceConfigurationList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMappedResourceConfigurationList() ? this.mappedResourceConfigurationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMappedResourceConfigurationResponse)) {
            return false;
        }
        DescribeMappedResourceConfigurationResponse other = (DescribeMappedResourceConfigurationResponse)((Object)obj);
        return this.hasMappedResourceConfigurationList() == other.hasMappedResourceConfigurationList() && Objects.equals(this.mappedResourceConfigurationList(), other.mappedResourceConfigurationList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMappedResourceConfigurationResponse").add("MappedResourceConfigurationList", this.hasMappedResourceConfigurationList() ? this.mappedResourceConfigurationList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MappedResourceConfigurationList": {
                return Optional.ofNullable(clazz.cast(this.mappedResourceConfigurationList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MappedResourceConfigurationList", MAPPED_RESOURCE_CONFIGURATION_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMappedResourceConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeMappedResourceConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoResponse.BuilderImpl
    implements Builder {
        private List<MappedResourceConfigurationListItem> mappedResourceConfigurationList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMappedResourceConfigurationResponse model) {
            super(model);
            this.mappedResourceConfigurationList(model.mappedResourceConfigurationList);
            this.nextToken(model.nextToken);
        }

        public final List<MappedResourceConfigurationListItem.Builder> getMappedResourceConfigurationList() {
            List<MappedResourceConfigurationListItem.Builder> result = MappedResourceConfigurationListCopier.copyToBuilder(this.mappedResourceConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMappedResourceConfigurationList(Collection<MappedResourceConfigurationListItem.BuilderImpl> mappedResourceConfigurationList) {
            this.mappedResourceConfigurationList = MappedResourceConfigurationListCopier.copyFromBuilder(mappedResourceConfigurationList);
        }

        @Override
        public final Builder mappedResourceConfigurationList(Collection<MappedResourceConfigurationListItem> mappedResourceConfigurationList) {
            this.mappedResourceConfigurationList = MappedResourceConfigurationListCopier.copy(mappedResourceConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedResourceConfigurationList(MappedResourceConfigurationListItem ... mappedResourceConfigurationList) {
            this.mappedResourceConfigurationList(Arrays.asList(mappedResourceConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedResourceConfigurationList(Consumer<MappedResourceConfigurationListItem.Builder> ... mappedResourceConfigurationList) {
            this.mappedResourceConfigurationList(Stream.of(mappedResourceConfigurationList).map(c -> (MappedResourceConfigurationListItem)((MappedResourceConfigurationListItem.Builder)MappedResourceConfigurationListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMappedResourceConfigurationResponse build() {
            return new DescribeMappedResourceConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KinesisVideoResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMappedResourceConfigurationResponse> {
        public Builder mappedResourceConfigurationList(Collection<MappedResourceConfigurationListItem> var1);

        public Builder mappedResourceConfigurationList(MappedResourceConfigurationListItem ... var1);

        public Builder mappedResourceConfigurationList(Consumer<MappedResourceConfigurationListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

