/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.services.kinesisvideo.model.MediaStorageConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMediaStorageConfigurationRequest
extends KinesisVideoRequest
implements ToCopyableBuilder<Builder, UpdateMediaStorageConfigurationRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelARN").getter(UpdateMediaStorageConfigurationRequest.getter(UpdateMediaStorageConfigurationRequest::channelARN)).setter(UpdateMediaStorageConfigurationRequest.setter(Builder::channelARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelARN").build()}).build();
    private static final SdkField<MediaStorageConfiguration> MEDIA_STORAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaStorageConfiguration").getter(UpdateMediaStorageConfigurationRequest.getter(UpdateMediaStorageConfigurationRequest::mediaStorageConfiguration)).setter(UpdateMediaStorageConfigurationRequest.setter(Builder::mediaStorageConfiguration)).constructor(MediaStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaStorageConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, MEDIA_STORAGE_CONFIGURATION_FIELD));
    private final String channelARN;
    private final MediaStorageConfiguration mediaStorageConfiguration;

    private UpdateMediaStorageConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.channelARN = builder.channelARN;
        this.mediaStorageConfiguration = builder.mediaStorageConfiguration;
    }

    public final String channelARN() {
        return this.channelARN;
    }

    public final MediaStorageConfiguration mediaStorageConfiguration() {
        return this.mediaStorageConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStorageConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMediaStorageConfigurationRequest)) {
            return false;
        }
        UpdateMediaStorageConfigurationRequest other = (UpdateMediaStorageConfigurationRequest)((Object)obj);
        return Objects.equals(this.channelARN(), other.channelARN()) && Objects.equals(this.mediaStorageConfiguration(), other.mediaStorageConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMediaStorageConfigurationRequest").add("ChannelARN", (Object)this.channelARN()).add("MediaStorageConfiguration", (Object)this.mediaStorageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelARN": {
                return Optional.ofNullable(clazz.cast(this.channelARN()));
            }
            case "MediaStorageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.mediaStorageConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMediaStorageConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateMediaStorageConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoRequest.BuilderImpl
    implements Builder {
        private String channelARN;
        private MediaStorageConfiguration mediaStorageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMediaStorageConfigurationRequest model) {
            super(model);
            this.channelARN(model.channelARN);
            this.mediaStorageConfiguration(model.mediaStorageConfiguration);
        }

        public final String getChannelARN() {
            return this.channelARN;
        }

        public final void setChannelARN(String channelARN) {
            this.channelARN = channelARN;
        }

        @Override
        public final Builder channelARN(String channelARN) {
            this.channelARN = channelARN;
            return this;
        }

        public final MediaStorageConfiguration.Builder getMediaStorageConfiguration() {
            return this.mediaStorageConfiguration != null ? this.mediaStorageConfiguration.toBuilder() : null;
        }

        public final void setMediaStorageConfiguration(MediaStorageConfiguration.BuilderImpl mediaStorageConfiguration) {
            this.mediaStorageConfiguration = mediaStorageConfiguration != null ? mediaStorageConfiguration.build() : null;
        }

        @Override
        public final Builder mediaStorageConfiguration(MediaStorageConfiguration mediaStorageConfiguration) {
            this.mediaStorageConfiguration = mediaStorageConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMediaStorageConfigurationRequest build() {
            return new UpdateMediaStorageConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMediaStorageConfigurationRequest> {
        public Builder channelARN(String var1);

        public Builder mediaStorageConfiguration(MediaStorageConfiguration var1);

        default public Builder mediaStorageConfiguration(Consumer<MediaStorageConfiguration.Builder> mediaStorageConfiguration) {
            return this.mediaStorageConfiguration((MediaStorageConfiguration)((MediaStorageConfiguration.Builder)MediaStorageConfiguration.builder().applyMutation(mediaStorageConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

