/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesisvideo.DefaultKinesisVideoBaseClientBuilder;
import software.amazon.awssdk.services.kinesisvideo.DefaultKinesisVideoClient;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoClient;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoClientBuilder;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisvideo.endpoints.KinesisVideoEndpointProvider;

@SdkInternalApi
final class DefaultKinesisVideoClientBuilder
extends DefaultKinesisVideoBaseClientBuilder<KinesisVideoClientBuilder, KinesisVideoClient>
implements KinesisVideoClientBuilder {
    DefaultKinesisVideoClientBuilder() {
    }

    @Override
    public DefaultKinesisVideoClientBuilder endpointProvider(KinesisVideoEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KinesisVideoClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultKinesisVideoClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        KinesisVideoServiceClientConfiguration serviceClientConfiguration = KinesisVideoServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultKinesisVideoClient(serviceClientConfiguration, clientConfiguration);
    }
}

