/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoResponse;
import software.amazon.awssdk.services.kinesisvideo.model.ResourceEndpointListCopier;
import software.amazon.awssdk.services.kinesisvideo.model.ResourceEndpointListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSignalingChannelEndpointResponse
extends KinesisVideoResponse
implements ToCopyableBuilder<Builder, GetSignalingChannelEndpointResponse> {
    private static final SdkField<List<ResourceEndpointListItem>> RESOURCE_ENDPOINT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceEndpointList").getter(GetSignalingChannelEndpointResponse.getter(GetSignalingChannelEndpointResponse::resourceEndpointList)).setter(GetSignalingChannelEndpointResponse.setter(Builder::resourceEndpointList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceEndpointList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceEndpointListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ENDPOINT_LIST_FIELD));
    private final List<ResourceEndpointListItem> resourceEndpointList;

    private GetSignalingChannelEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.resourceEndpointList = builder.resourceEndpointList;
    }

    public final boolean hasResourceEndpointList() {
        return this.resourceEndpointList != null && !(this.resourceEndpointList instanceof SdkAutoConstructList);
    }

    public final List<ResourceEndpointListItem> resourceEndpointList() {
        return this.resourceEndpointList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceEndpointList() ? this.resourceEndpointList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSignalingChannelEndpointResponse)) {
            return false;
        }
        GetSignalingChannelEndpointResponse other = (GetSignalingChannelEndpointResponse)((Object)obj);
        return this.hasResourceEndpointList() == other.hasResourceEndpointList() && Objects.equals(this.resourceEndpointList(), other.resourceEndpointList());
    }

    public final String toString() {
        return ToString.builder((String)"GetSignalingChannelEndpointResponse").add("ResourceEndpointList", this.hasResourceEndpointList() ? this.resourceEndpointList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceEndpointList": {
                return Optional.ofNullable(clazz.cast(this.resourceEndpointList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSignalingChannelEndpointResponse, T> g) {
        return obj -> g.apply((GetSignalingChannelEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoResponse.BuilderImpl
    implements Builder {
        private List<ResourceEndpointListItem> resourceEndpointList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSignalingChannelEndpointResponse model) {
            super(model);
            this.resourceEndpointList(model.resourceEndpointList);
        }

        public final List<ResourceEndpointListItem.Builder> getResourceEndpointList() {
            List<ResourceEndpointListItem.Builder> result = ResourceEndpointListCopier.copyToBuilder(this.resourceEndpointList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder resourceEndpointList(Collection<ResourceEndpointListItem> resourceEndpointList) {
            this.resourceEndpointList = ResourceEndpointListCopier.copy(resourceEndpointList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceEndpointList(ResourceEndpointListItem ... resourceEndpointList) {
            this.resourceEndpointList(Arrays.asList(resourceEndpointList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceEndpointList(Consumer<ResourceEndpointListItem.Builder> ... resourceEndpointList) {
            this.resourceEndpointList(Stream.of(resourceEndpointList).map(c -> (ResourceEndpointListItem)((ResourceEndpointListItem.Builder)ResourceEndpointListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceEndpointList(Collection<ResourceEndpointListItem.BuilderImpl> resourceEndpointList) {
            this.resourceEndpointList = ResourceEndpointListCopier.copyFromBuilder(resourceEndpointList);
        }

        @Override
        public GetSignalingChannelEndpointResponse build() {
            return new GetSignalingChannelEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSignalingChannelEndpointResponse> {
        public Builder resourceEndpointList(Collection<ResourceEndpointListItem> var1);

        public Builder resourceEndpointList(ResourceEndpointListItem ... var1);

        public Builder resourceEndpointList(Consumer<ResourceEndpointListItem.Builder> ... var1);
    }
}

