/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.services.kinesisvideo.model.TagKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UntagStreamRequest
extends KinesisVideoRequest
implements ToCopyableBuilder<Builder, UntagStreamRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(UntagStreamRequest.getter(UntagStreamRequest::streamARN)).setter(UntagStreamRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(UntagStreamRequest.getter(UntagStreamRequest::streamName)).setter(UntagStreamRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<List<String>> TAG_KEY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagKeyList").getter(UntagStreamRequest.getter(UntagStreamRequest::tagKeyList)).setter(UntagStreamRequest.setter(Builder::tagKeyList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeyList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, STREAM_NAME_FIELD, TAG_KEY_LIST_FIELD));
    private final String streamARN;
    private final String streamName;
    private final List<String> tagKeyList;

    private UntagStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.streamName = builder.streamName;
        this.tagKeyList = builder.tagKeyList;
    }

    public String streamARN() {
        return this.streamARN;
    }

    public String streamName() {
        return this.streamName;
    }

    public boolean hasTagKeyList() {
        return this.tagKeyList != null && !(this.tagKeyList instanceof SdkAutoConstructList);
    }

    public List<String> tagKeyList() {
        return this.tagKeyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeyList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagStreamRequest)) {
            return false;
        }
        UntagStreamRequest other = (UntagStreamRequest)((Object)obj);
        return Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.tagKeyList(), other.tagKeyList());
    }

    public String toString() {
        return ToString.builder((String)"UntagStreamRequest").add("StreamARN", (Object)this.streamARN()).add("StreamName", (Object)this.streamName()).add("TagKeyList", this.tagKeyList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "TagKeyList": {
                return Optional.ofNullable(clazz.cast(this.tagKeyList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UntagStreamRequest, T> g) {
        return obj -> g.apply((UntagStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoRequest.BuilderImpl
    implements Builder {
        private String streamARN;
        private String streamName;
        private List<String> tagKeyList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UntagStreamRequest model) {
            super(model);
            this.streamARN(model.streamARN);
            this.streamName(model.streamName);
            this.tagKeyList(model.tagKeyList);
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getTagKeyList() {
            return this.tagKeyList;
        }

        @Override
        public final Builder tagKeyList(Collection<String> tagKeyList) {
            this.tagKeyList = TagKeyListCopier.copy(tagKeyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeyList(String ... tagKeyList) {
            this.tagKeyList(Arrays.asList(tagKeyList));
            return this;
        }

        public final void setTagKeyList(Collection<String> tagKeyList) {
            this.tagKeyList = TagKeyListCopier.copy(tagKeyList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UntagStreamRequest build() {
            return new UntagStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UntagStreamRequest> {
        public Builder streamARN(String var1);

        public Builder streamName(String var1);

        public Builder tagKeyList(Collection<String> var1);

        public Builder tagKeyList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

