/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateDataRetentionOperation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDataRetentionRequest
extends KinesisVideoRequest
implements ToCopyableBuilder<Builder, UpdateDataRetentionRequest> {
    private final String streamName;
    private final String streamARN;
    private final String currentVersion;
    private final String operation;
    private final Integer dataRetentionChangeInHours;

    private UpdateDataRetentionRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.currentVersion = builder.currentVersion;
        this.operation = builder.operation;
        this.dataRetentionChangeInHours = builder.dataRetentionChangeInHours;
    }

    public String streamName() {
        return this.streamName;
    }

    public String streamARN() {
        return this.streamARN;
    }

    public String currentVersion() {
        return this.currentVersion;
    }

    public UpdateDataRetentionOperation operation() {
        return UpdateDataRetentionOperation.fromValue(this.operation);
    }

    public String operationString() {
        return this.operation;
    }

    public Integer dataRetentionChangeInHours() {
        return this.dataRetentionChangeInHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRetentionChangeInHours());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataRetentionRequest)) {
            return false;
        }
        UpdateDataRetentionRequest other = (UpdateDataRetentionRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.operationString(), other.operationString()) && Objects.equals(this.dataRetentionChangeInHours(), other.dataRetentionChangeInHours());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDataRetentionRequest").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("CurrentVersion", (Object)this.currentVersion()).add("Operation", (Object)this.operationString()).add("DataRetentionChangeInHours", (Object)this.dataRetentionChangeInHours()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.of(clazz.cast(this.streamARN()));
            }
            case "CurrentVersion": {
                return Optional.of(clazz.cast(this.currentVersion()));
            }
            case "Operation": {
                return Optional.of(clazz.cast(this.operationString()));
            }
            case "DataRetentionChangeInHours": {
                return Optional.of(clazz.cast(this.dataRetentionChangeInHours()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisVideoRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private String currentVersion;
        private String operation;
        private Integer dataRetentionChangeInHours;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataRetentionRequest model) {
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.currentVersion(model.currentVersion);
            this.operation(model.operation);
            this.dataRetentionChangeInHours(model.dataRetentionChangeInHours);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final String getOperation() {
            return this.operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(UpdateDataRetentionOperation operation) {
            this.operation(operation.toString());
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final Integer getDataRetentionChangeInHours() {
            return this.dataRetentionChangeInHours;
        }

        @Override
        public final Builder dataRetentionChangeInHours(Integer dataRetentionChangeInHours) {
            this.dataRetentionChangeInHours = dataRetentionChangeInHours;
            return this;
        }

        public final void setDataRetentionChangeInHours(Integer dataRetentionChangeInHours) {
            this.dataRetentionChangeInHours = dataRetentionChangeInHours;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataRetentionRequest build() {
            return new UpdateDataRetentionRequest(this);
        }
    }

    public static interface Builder
    extends KinesisVideoRequest.Builder,
    CopyableBuilder<Builder, UpdateDataRetentionRequest> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder currentVersion(String var1);

        public Builder operation(String var1);

        public Builder operation(UpdateDataRetentionOperation var1);

        public Builder dataRetentionChangeInHours(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

