/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo;

import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.kinesisvideo.DefaultKinesisVideoClientBuilder;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoClientBuilder;
import software.amazon.awssdk.services.kinesisvideo.model.AccountStreamLimitExceededException;
import software.amazon.awssdk.services.kinesisvideo.model.ClientLimitExceededException;
import software.amazon.awssdk.services.kinesisvideo.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.CreateStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DeleteStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DeleteStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DeviceStreamLimitExceededException;
import software.amazon.awssdk.services.kinesisvideo.model.GetDataEndpointRequest;
import software.amazon.awssdk.services.kinesisvideo.model.GetDataEndpointResponse;
import software.amazon.awssdk.services.kinesisvideo.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesisvideo.model.InvalidDeviceException;
import software.amazon.awssdk.services.kinesisvideo.model.InvalidResourceFormatException;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoException;
import software.amazon.awssdk.services.kinesisvideo.model.ListStreamsRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListStreamsResponse;
import software.amazon.awssdk.services.kinesisvideo.model.ListTagsForStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListTagsForStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.NotAuthorizedException;
import software.amazon.awssdk.services.kinesisvideo.model.ResourceInUseException;
import software.amazon.awssdk.services.kinesisvideo.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesisvideo.model.TagStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.TagStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.TagsPerResourceExceededLimitException;
import software.amazon.awssdk.services.kinesisvideo.model.UntagStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UntagStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateDataRetentionRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateDataRetentionResponse;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.VersionMismatchException;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface KinesisVideoClient
extends SdkClient,
SdkAutoCloseable {
    public static final String SERVICE_NAME = "kinesisvideo";

    public static KinesisVideoClient create() {
        return (KinesisVideoClient)KinesisVideoClient.builder().build();
    }

    public static KinesisVideoClientBuilder builder() {
        return new DefaultKinesisVideoClientBuilder();
    }

    default public CreateStreamResponse createStream(CreateStreamRequest createStreamRequest) throws AccountStreamLimitExceededException, DeviceStreamLimitExceededException, ResourceInUseException, InvalidDeviceException, InvalidArgumentException, ClientLimitExceededException, SdkServiceException, SdkClientException, KinesisVideoException {
        throw new UnsupportedOperationException();
    }

    default public CreateStreamResponse createStream(Consumer<CreateStreamRequest.Builder> createStreamRequest) throws AccountStreamLimitExceededException, DeviceStreamLimitExceededException, ResourceInUseException, InvalidDeviceException, InvalidArgumentException, ClientLimitExceededException, SdkServiceException, SdkClientException, KinesisVideoException {
        return this.createStream((CreateStreamRequest)((Object)((CreateStreamRequest.Builder)CreateStreamRequest.builder().apply(createStreamRequest)).build()));
    }

    default public DeleteStreamResponse deleteStream(DeleteStreamRequest deleteStreamRequest) throws ClientLimitExceededException, InvalidArgumentException, ResourceNotFoundException, NotAuthorizedException, SdkServiceException, SdkClientException, KinesisVideoException {
        throw new UnsupportedOperationException();
    }

    default public DeleteStreamResponse deleteStream(Consumer<DeleteStreamRequest.Builder> deleteStreamRequest) throws ClientLimitExceededException, InvalidArgumentException, ResourceNotFoundException, NotAuthorizedException, SdkServiceException, SdkClientException, KinesisVideoException {
        return this.deleteStream((DeleteStreamRequest)((Object)((DeleteStreamRequest.Builder)DeleteStreamRequest.builder().apply(deleteStreamRequest)).build()));
    }

    default public DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) throws InvalidArgumentException, ResourceNotFoundException, ClientLimitExceededException, NotAuthorizedException, SdkServiceException, SdkClientException, KinesisVideoException {
        throw new UnsupportedOperationException();
    }

    default public DescribeStreamResponse describeStream(Consumer<DescribeStreamRequest.Builder> describeStreamRequest) throws InvalidArgumentException, ResourceNotFoundException, ClientLimitExceededException, NotAuthorizedException, SdkServiceException, SdkClientException, KinesisVideoException {
        return this.describeStream((DescribeStreamRequest)((Object)((DescribeStreamRequest.Builder)DescribeStreamRequest.builder().apply(describeStreamRequest)).build()));
    }

    default public GetDataEndpointResponse getDataEndpoint(GetDataEndpointRequest getDataEndpointRequest) throws InvalidArgumentException, ResourceNotFoundException, ClientLimitExceededException, NotAuthorizedException, SdkServiceException, SdkClientException, KinesisVideoException {
        throw new UnsupportedOperationException();
    }

    default public GetDataEndpointResponse getDataEndpoint(Consumer<GetDataEndpointRequest.Builder> getDataEndpointRequest) throws InvalidArgumentException, ResourceNotFoundException, ClientLimitExceededException, NotAuthorizedException, SdkServiceException, SdkClientException, KinesisVideoException {
        return this.getDataEndpoint((GetDataEndpointRequest)((Object)((GetDataEndpointRequest.Builder)GetDataEndpointRequest.builder().apply(getDataEndpointRequest)).build()));
    }

    default public ListStreamsResponse listStreams() throws ClientLimitExceededException, InvalidArgumentException, SdkServiceException, SdkClientException, KinesisVideoException {
        return this.listStreams((ListStreamsRequest)((Object)ListStreamsRequest.builder().build()));
    }

    default public ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) throws ClientLimitExceededException, InvalidArgumentException, SdkServiceException, SdkClientException, KinesisVideoException {
        throw new UnsupportedOperationException();
    }

    default public ListStreamsResponse listStreams(Consumer<ListStreamsRequest.Builder> listStreamsRequest) throws ClientLimitExceededException, InvalidArgumentException, SdkServiceException, SdkClientException, KinesisVideoException {
        return this.listStreams((ListStreamsRequest)((Object)((ListStreamsRequest.Builder)ListStreamsRequest.builder().apply(listStreamsRequest)).build()));
    }

    default public ListTagsForStreamResponse listTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) throws ClientLimitExceededException, InvalidArgumentException, ResourceNotFoundException, NotAuthorizedException, InvalidResourceFormatException, SdkServiceException, SdkClientException, KinesisVideoException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForStreamResponse listTagsForStream(Consumer<ListTagsForStreamRequest.Builder> listTagsForStreamRequest) throws ClientLimitExceededException, InvalidArgumentException, ResourceNotFoundException, NotAuthorizedException, InvalidResourceFormatException, SdkServiceException, SdkClientException, KinesisVideoException {
        return this.listTagsForStream((ListTagsForStreamRequest)((Object)((ListTagsForStreamRequest.Builder)ListTagsForStreamRequest.builder().apply(listTagsForStreamRequest)).build()));
    }

    default public TagStreamResponse tagStream(TagStreamRequest tagStreamRequest) throws ClientLimitExceededException, InvalidArgumentException, ResourceNotFoundException, NotAuthorizedException, InvalidResourceFormatException, TagsPerResourceExceededLimitException, SdkServiceException, SdkClientException, KinesisVideoException {
        throw new UnsupportedOperationException();
    }

    default public TagStreamResponse tagStream(Consumer<TagStreamRequest.Builder> tagStreamRequest) throws ClientLimitExceededException, InvalidArgumentException, ResourceNotFoundException, NotAuthorizedException, InvalidResourceFormatException, TagsPerResourceExceededLimitException, SdkServiceException, SdkClientException, KinesisVideoException {
        return this.tagStream((TagStreamRequest)((Object)((TagStreamRequest.Builder)TagStreamRequest.builder().apply(tagStreamRequest)).build()));
    }

    default public UntagStreamResponse untagStream(UntagStreamRequest untagStreamRequest) throws ClientLimitExceededException, InvalidArgumentException, ResourceNotFoundException, NotAuthorizedException, InvalidResourceFormatException, SdkServiceException, SdkClientException, KinesisVideoException {
        throw new UnsupportedOperationException();
    }

    default public UntagStreamResponse untagStream(Consumer<UntagStreamRequest.Builder> untagStreamRequest) throws ClientLimitExceededException, InvalidArgumentException, ResourceNotFoundException, NotAuthorizedException, InvalidResourceFormatException, SdkServiceException, SdkClientException, KinesisVideoException {
        return this.untagStream((UntagStreamRequest)((Object)((UntagStreamRequest.Builder)UntagStreamRequest.builder().apply(untagStreamRequest)).build()));
    }

    default public UpdateDataRetentionResponse updateDataRetention(UpdateDataRetentionRequest updateDataRetentionRequest) throws ClientLimitExceededException, InvalidArgumentException, ResourceNotFoundException, ResourceInUseException, NotAuthorizedException, VersionMismatchException, SdkServiceException, SdkClientException, KinesisVideoException {
        throw new UnsupportedOperationException();
    }

    default public UpdateDataRetentionResponse updateDataRetention(Consumer<UpdateDataRetentionRequest.Builder> updateDataRetentionRequest) throws ClientLimitExceededException, InvalidArgumentException, ResourceNotFoundException, ResourceInUseException, NotAuthorizedException, VersionMismatchException, SdkServiceException, SdkClientException, KinesisVideoException {
        return this.updateDataRetention((UpdateDataRetentionRequest)((Object)((UpdateDataRetentionRequest.Builder)UpdateDataRetentionRequest.builder().apply(updateDataRetentionRequest)).build()));
    }

    default public UpdateStreamResponse updateStream(UpdateStreamRequest updateStreamRequest) throws ClientLimitExceededException, InvalidArgumentException, ResourceNotFoundException, ResourceInUseException, NotAuthorizedException, VersionMismatchException, SdkServiceException, SdkClientException, KinesisVideoException {
        throw new UnsupportedOperationException();
    }

    default public UpdateStreamResponse updateStream(Consumer<UpdateStreamRequest.Builder> updateStreamRequest) throws ClientLimitExceededException, InvalidArgumentException, ResourceNotFoundException, ResourceInUseException, NotAuthorizedException, VersionMismatchException, SdkServiceException, SdkClientException, KinesisVideoException {
        return this.updateStream((UpdateStreamRequest)((Object)((UpdateStreamRequest.Builder)UpdateStreamRequest.builder().apply(updateStreamRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

