/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisvideo.model.StreamInfo;

@SdkInternalApi
public class StreamInfoMarshaller {
    private static final MarshallingInfo<String> DEVICENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceName").build();
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamARN").build();
    private static final MarshallingInfo<String> MEDIATYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MediaType").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").build();
    private static final MarshallingInfo<Integer> DATARETENTIONINHOURS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRetentionInHours").build();
    private static final StreamInfoMarshaller INSTANCE = new StreamInfoMarshaller();

    public static StreamInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StreamInfo streamInfo, ProtocolMarshaller protocolMarshaller) {
        if (streamInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)streamInfo.deviceName(), DEVICENAME_BINDING);
            protocolMarshaller.marshall((Object)streamInfo.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)streamInfo.streamARN(), STREAMARN_BINDING);
            protocolMarshaller.marshall((Object)streamInfo.mediaType(), MEDIATYPE_BINDING);
            protocolMarshaller.marshall((Object)streamInfo.kmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)streamInfo.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)streamInfo.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)streamInfo.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)streamInfo.dataRetentionInHours(), DATARETENTIONINHOURS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

