/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisvideo.model.CreateStreamRequest;

@SdkInternalApi
public class CreateStreamRequestModelMarshaller {
    private static final MarshallingInfo<String> DEVICENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceName").build();
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final MarshallingInfo<String> MEDIATYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MediaType").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").build();
    private static final MarshallingInfo<Integer> DATARETENTIONINHOURS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRetentionInHours").build();
    private static final CreateStreamRequestModelMarshaller INSTANCE = new CreateStreamRequestModelMarshaller();

    public static CreateStreamRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateStreamRequest createStreamRequest, ProtocolMarshaller protocolMarshaller) {
        if (createStreamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createStreamRequest.deviceName(), DEVICENAME_BINDING);
            protocolMarshaller.marshall((Object)createStreamRequest.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)createStreamRequest.mediaType(), MEDIATYPE_BINDING);
            protocolMarshaller.marshall((Object)createStreamRequest.kmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)createStreamRequest.dataRetentionInHours(), DATARETENTIONINHOURS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

