/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisvideo.model.ComparisonOperator;
import software.amazon.awssdk.services.kinesisvideo.transform.StreamNameConditionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StreamNameCondition
implements StructuredPojo,
ToCopyableBuilder<Builder, StreamNameCondition> {
    private final String comparisonOperator;
    private final String comparisonValue;

    private StreamNameCondition(BuilderImpl builder) {
        this.comparisonOperator = builder.comparisonOperator;
        this.comparisonValue = builder.comparisonValue;
    }

    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorString() {
        return this.comparisonOperator;
    }

    public String comparisonValue() {
        return this.comparisonValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamNameCondition)) {
            return false;
        }
        StreamNameCondition other = (StreamNameCondition)obj;
        return Objects.equals(this.comparisonOperatorString(), other.comparisonOperatorString()) && Objects.equals(this.comparisonValue(), other.comparisonValue());
    }

    public String toString() {
        return ToString.builder((String)"StreamNameCondition").add("ComparisonOperator", (Object)this.comparisonOperatorString()).add("ComparisonValue", (Object)this.comparisonValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComparisonOperator": {
                return Optional.of(clazz.cast(this.comparisonOperatorString()));
            }
            case "ComparisonValue": {
                return Optional.of(clazz.cast(this.comparisonValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamNameConditionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String comparisonOperator;
        private String comparisonValue;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamNameCondition model) {
            this.comparisonOperator(model.comparisonOperator);
            this.comparisonValue(model.comparisonValue);
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final String getComparisonValue() {
            return this.comparisonValue;
        }

        @Override
        public final Builder comparisonValue(String comparisonValue) {
            this.comparisonValue = comparisonValue;
            return this;
        }

        public final void setComparisonValue(String comparisonValue) {
            this.comparisonValue = comparisonValue;
        }

        public StreamNameCondition build() {
            return new StreamNameCondition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamNameCondition> {
        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder comparisonValue(String var1);
    }
}

