/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesisvideo.model.StreamInfo;

public class StreamInfoUnmarshaller
implements Unmarshaller<StreamInfo, JsonUnmarshallerContext> {
    private static final StreamInfoUnmarshaller INSTANCE = new StreamInfoUnmarshaller();

    public StreamInfo unmarshall(JsonUnmarshallerContext context) throws Exception {
        StreamInfo.Builder streamInfoBuilder = StreamInfo.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DeviceName", targetDepth)) {
                    context.nextToken();
                    streamInfoBuilder.deviceName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StreamName", targetDepth)) {
                    context.nextToken();
                    streamInfoBuilder.streamName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StreamARN", targetDepth)) {
                    context.nextToken();
                    streamInfoBuilder.streamARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("MediaType", targetDepth)) {
                    context.nextToken();
                    streamInfoBuilder.mediaType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    context.nextToken();
                    streamInfoBuilder.kmsKeyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Version", targetDepth)) {
                    context.nextToken();
                    streamInfoBuilder.version((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    streamInfoBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    streamInfoBuilder.creationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataRetentionInHours", targetDepth)) {
                    context.nextToken();
                    streamInfoBuilder.dataRetentionInHours((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (StreamInfo)streamInfoBuilder.build();
    }

    public static StreamInfoUnmarshaller getInstance() {
        return INSTANCE;
    }
}

