/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.services.kinesisvideo.model.TagKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UntagStreamRequest
extends KinesisVideoRequest
implements ToCopyableBuilder<Builder, UntagStreamRequest> {
    private final String streamARN;
    private final String streamName;
    private final List<String> tagKeyList;

    private UntagStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.streamName = builder.streamName;
        this.tagKeyList = builder.tagKeyList;
    }

    public String streamARN() {
        return this.streamARN;
    }

    public String streamName() {
        return this.streamName;
    }

    public List<String> tagKeyList() {
        return this.tagKeyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeyList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagStreamRequest)) {
            return false;
        }
        UntagStreamRequest other = (UntagStreamRequest)((Object)obj);
        return Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.tagKeyList(), other.tagKeyList());
    }

    public String toString() {
        return ToString.builder((String)"UntagStreamRequest").add("StreamARN", (Object)this.streamARN()).add("StreamName", (Object)this.streamName()).add("TagKeyList", this.tagKeyList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamARN": {
                return Optional.of(clazz.cast(this.streamARN()));
            }
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "TagKeyList": {
                return Optional.of(clazz.cast(this.tagKeyList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisVideoRequest.BuilderImpl
    implements Builder {
        private String streamARN;
        private String streamName;
        private List<String> tagKeyList;

        private BuilderImpl() {
        }

        private BuilderImpl(UntagStreamRequest model) {
            super(model);
            this.streamARN(model.streamARN);
            this.streamName(model.streamName);
            this.tagKeyList(model.tagKeyList);
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getTagKeyList() {
            return this.tagKeyList;
        }

        @Override
        public final Builder tagKeyList(Collection<String> tagKeyList) {
            this.tagKeyList = TagKeyListCopier.copy(tagKeyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeyList(String ... tagKeyList) {
            this.tagKeyList(Arrays.asList(tagKeyList));
            return this;
        }

        public final void setTagKeyList(Collection<String> tagKeyList) {
            this.tagKeyList = TagKeyListCopier.copy(tagKeyList);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UntagStreamRequest build() {
            return new UntagStreamRequest(this);
        }
    }

    public static interface Builder
    extends KinesisVideoRequest.Builder,
    CopyableBuilder<Builder, UntagStreamRequest> {
        public Builder streamARN(String var1);

        public Builder streamName(String var1);

        public Builder tagKeyList(Collection<String> var1);

        public Builder tagKeyList(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

