/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kinesisvideo.model.APIName;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDataEndpointRequest
extends KinesisVideoRequest
implements ToCopyableBuilder<Builder, GetDataEndpointRequest> {
    private final String streamName;
    private final String streamARN;
    private final String apiName;

    private GetDataEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.apiName = builder.apiName;
    }

    public String streamName() {
        return this.streamName;
    }

    public String streamARN() {
        return this.streamARN;
    }

    public APIName apiName() {
        return APIName.fromValue(this.apiName);
    }

    public String apiNameAsString() {
        return this.apiName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiNameAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataEndpointRequest)) {
            return false;
        }
        GetDataEndpointRequest other = (GetDataEndpointRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.apiNameAsString(), other.apiNameAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetDataEndpointRequest").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("APIName", (Object)this.apiNameAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.of(clazz.cast(this.streamARN()));
            }
            case "APIName": {
                return Optional.of(clazz.cast(this.apiNameAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisVideoRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private String apiName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataEndpointRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.apiName(model.apiName);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getAPIName() {
            return this.apiName;
        }

        @Override
        public final Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        @Override
        public final Builder apiName(APIName apiName) {
            this.apiName(apiName.toString());
            return this;
        }

        public final void setAPIName(String apiName) {
            this.apiName = apiName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetDataEndpointRequest build() {
            return new GetDataEndpointRequest(this);
        }
    }

    public static interface Builder
    extends KinesisVideoRequest.Builder,
    CopyableBuilder<Builder, GetDataEndpointRequest> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder apiName(String var1);

        public Builder apiName(APIName var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

