/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddApplicationCloudWatchLoggingOptionResponse
extends KinesisAnalyticsV2Response
implements ToCopyableBuilder<Builder, AddApplicationCloudWatchLoggingOptionResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddApplicationCloudWatchLoggingOptionResponse.getter(AddApplicationCloudWatchLoggingOptionResponse::applicationARN)).setter(AddApplicationCloudWatchLoggingOptionResponse.setter(Builder::applicationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(AddApplicationCloudWatchLoggingOptionResponse.getter(AddApplicationCloudWatchLoggingOptionResponse::applicationVersionId)).setter(AddApplicationCloudWatchLoggingOptionResponse.setter(Builder::applicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build()}).build();
    private static final SdkField<List<CloudWatchLoggingOptionDescription>> CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AddApplicationCloudWatchLoggingOptionResponse.getter(AddApplicationCloudWatchLoggingOptionResponse::cloudWatchLoggingOptionDescriptions)).setter(AddApplicationCloudWatchLoggingOptionResponse.setter(Builder::cloudWatchLoggingOptionDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptionDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchLoggingOptionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, APPLICATION_VERSION_ID_FIELD, CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD));
    private final String applicationARN;
    private final Long applicationVersionId;
    private final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions;

    private AddApplicationCloudWatchLoggingOptionResponse(BuilderImpl builder) {
        super(builder);
        this.applicationARN = builder.applicationARN;
        this.applicationVersionId = builder.applicationVersionId;
        this.cloudWatchLoggingOptionDescriptions = builder.cloudWatchLoggingOptionDescriptions;
    }

    public String applicationARN() {
        return this.applicationARN;
    }

    public Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions() {
        return this.cloudWatchLoggingOptionDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptionDescriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationCloudWatchLoggingOptionResponse)) {
            return false;
        }
        AddApplicationCloudWatchLoggingOptionResponse other = (AddApplicationCloudWatchLoggingOptionResponse)((Object)obj);
        return Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationVersionId(), other.applicationVersionId()) && Objects.equals(this.cloudWatchLoggingOptionDescriptions(), other.cloudWatchLoggingOptionDescriptions());
    }

    public String toString() {
        return ToString.builder((String)"AddApplicationCloudWatchLoggingOptionResponse").add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationVersionId", (Object)this.applicationVersionId()).add("CloudWatchLoggingOptionDescriptions", this.cloudWatchLoggingOptionDescriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationARN": {
                return Optional.ofNullable(clazz.cast(this.applicationARN()));
            }
            case "ApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionId()));
            }
            case "CloudWatchLoggingOptionDescriptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptionDescriptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationCloudWatchLoggingOptionResponse, T> g) {
        return obj -> g.apply((AddApplicationCloudWatchLoggingOptionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Response.BuilderImpl
    implements Builder {
        private String applicationARN;
        private Long applicationVersionId;
        private List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationCloudWatchLoggingOptionResponse model) {
            super(model);
            this.applicationARN(model.applicationARN);
            this.applicationVersionId(model.applicationVersionId);
            this.cloudWatchLoggingOptionDescriptions(model.cloudWatchLoggingOptionDescriptions);
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        public final Collection<CloudWatchLoggingOptionDescription.Builder> getCloudWatchLoggingOptionDescriptions() {
            return this.cloudWatchLoggingOptionDescriptions != null ? (Collection)this.cloudWatchLoggingOptionDescriptions.stream().map(CloudWatchLoggingOptionDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier.copy(cloudWatchLoggingOptionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription ... cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions(Arrays.asList(cloudWatchLoggingOptionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(Consumer<CloudWatchLoggingOptionDescription.Builder> ... cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions(Stream.of(cloudWatchLoggingOptionDescriptions).map(c -> (CloudWatchLoggingOptionDescription)((CloudWatchLoggingOptionDescription.Builder)CloudWatchLoggingOptionDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription.BuilderImpl> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier.copyFromBuilder(cloudWatchLoggingOptionDescriptions);
        }

        @Override
        public AddApplicationCloudWatchLoggingOptionResponse build() {
            return new AddApplicationCloudWatchLoggingOptionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddApplicationCloudWatchLoggingOptionResponse> {
        public Builder applicationARN(String var1);

        public Builder applicationVersionId(Long var1);

        public Builder cloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription> var1);

        public Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription ... var1);

        public Builder cloudWatchLoggingOptionDescriptions(Consumer<CloudWatchLoggingOptionDescription.Builder> ... var1);
    }
}

