/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotDetails> {
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SnapshotDetails.getter(SnapshotDetails::snapshotName)).setter(SnapshotDetails.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()}).build();
    private static final SdkField<String> SNAPSHOT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SnapshotDetails.getter(SnapshotDetails::snapshotStatusAsString)).setter(SnapshotDetails.setter(Builder::snapshotStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotStatus").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(SnapshotDetails.getter(SnapshotDetails::applicationVersionId)).setter(SnapshotDetails.setter(Builder::applicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build()}).build();
    private static final SdkField<Instant> SNAPSHOT_CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SnapshotDetails.getter(SnapshotDetails::snapshotCreationTimestamp)).setter(SnapshotDetails.setter(Builder::snapshotCreationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCreationTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_NAME_FIELD, SNAPSHOT_STATUS_FIELD, APPLICATION_VERSION_ID_FIELD, SNAPSHOT_CREATION_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String snapshotName;
    private final String snapshotStatus;
    private final Long applicationVersionId;
    private final Instant snapshotCreationTimestamp;

    private SnapshotDetails(BuilderImpl builder) {
        this.snapshotName = builder.snapshotName;
        this.snapshotStatus = builder.snapshotStatus;
        this.applicationVersionId = builder.applicationVersionId;
        this.snapshotCreationTimestamp = builder.snapshotCreationTimestamp;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public SnapshotStatus snapshotStatus() {
        return SnapshotStatus.fromValue(this.snapshotStatus);
    }

    public String snapshotStatusAsString() {
        return this.snapshotStatus;
    }

    public Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public Instant snapshotCreationTimestamp() {
        return this.snapshotCreationTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCreationTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotDetails)) {
            return false;
        }
        SnapshotDetails other = (SnapshotDetails)obj;
        return Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.snapshotStatusAsString(), other.snapshotStatusAsString()) && Objects.equals(this.applicationVersionId(), other.applicationVersionId()) && Objects.equals(this.snapshotCreationTimestamp(), other.snapshotCreationTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"SnapshotDetails").add("SnapshotName", (Object)this.snapshotName()).add("SnapshotStatus", (Object)this.snapshotStatusAsString()).add("ApplicationVersionId", (Object)this.applicationVersionId()).add("SnapshotCreationTimestamp", (Object)this.snapshotCreationTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
            case "SnapshotStatus": {
                return Optional.ofNullable(clazz.cast(this.snapshotStatusAsString()));
            }
            case "ApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionId()));
            }
            case "SnapshotCreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.snapshotCreationTimestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotDetails, T> g) {
        return obj -> g.apply((SnapshotDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotName;
        private String snapshotStatus;
        private Long applicationVersionId;
        private Instant snapshotCreationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotDetails model) {
            this.snapshotName(model.snapshotName);
            this.snapshotStatus(model.snapshotStatus);
            this.applicationVersionId(model.applicationVersionId);
            this.snapshotCreationTimestamp(model.snapshotCreationTimestamp);
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        public final String getSnapshotStatusAsString() {
            return this.snapshotStatus;
        }

        @Override
        public final Builder snapshotStatus(String snapshotStatus) {
            this.snapshotStatus = snapshotStatus;
            return this;
        }

        @Override
        public final Builder snapshotStatus(SnapshotStatus snapshotStatus) {
            this.snapshotStatus(snapshotStatus.toString());
            return this;
        }

        public final void setSnapshotStatus(String snapshotStatus) {
            this.snapshotStatus = snapshotStatus;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        public final Instant getSnapshotCreationTimestamp() {
            return this.snapshotCreationTimestamp;
        }

        @Override
        public final Builder snapshotCreationTimestamp(Instant snapshotCreationTimestamp) {
            this.snapshotCreationTimestamp = snapshotCreationTimestamp;
            return this;
        }

        public final void setSnapshotCreationTimestamp(Instant snapshotCreationTimestamp) {
            this.snapshotCreationTimestamp = snapshotCreationTimestamp;
        }

        public SnapshotDetails build() {
            return new SnapshotDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotDetails> {
        public Builder snapshotName(String var1);

        public Builder snapshotStatus(String var1);

        public Builder snapshotStatus(SnapshotStatus var1);

        public Builder applicationVersionId(Long var1);

        public Builder snapshotCreationTimestamp(Instant var1);
    }
}

