/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ReferenceDataSourceDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ReferenceDataSourceDescription> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3ReferenceDataSourceDescription.getter(S3ReferenceDataSourceDescription::bucketARN)).setter(S3ReferenceDataSourceDescription.setter(Builder::bucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARN").build()}).build();
    private static final SdkField<String> FILE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3ReferenceDataSourceDescription.getter(S3ReferenceDataSourceDescription::fileKey)).setter(S3ReferenceDataSourceDescription.setter(Builder::fileKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileKey").build()}).build();
    private static final SdkField<String> REFERENCE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3ReferenceDataSourceDescription.getter(S3ReferenceDataSourceDescription::referenceRoleARN)).setter(S3ReferenceDataSourceDescription.setter(Builder::referenceRoleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceRoleARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD, FILE_KEY_FIELD, REFERENCE_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketARN;
    private final String fileKey;
    private final String referenceRoleARN;

    private S3ReferenceDataSourceDescription(BuilderImpl builder) {
        this.bucketARN = builder.bucketARN;
        this.fileKey = builder.fileKey;
        this.referenceRoleARN = builder.referenceRoleARN;
    }

    public String bucketARN() {
        return this.bucketARN;
    }

    public String fileKey() {
        return this.fileKey;
    }

    public String referenceRoleARN() {
        return this.referenceRoleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceRoleARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ReferenceDataSourceDescription)) {
            return false;
        }
        S3ReferenceDataSourceDescription other = (S3ReferenceDataSourceDescription)obj;
        return Objects.equals(this.bucketARN(), other.bucketARN()) && Objects.equals(this.fileKey(), other.fileKey()) && Objects.equals(this.referenceRoleARN(), other.referenceRoleARN());
    }

    public String toString() {
        return ToString.builder((String)"S3ReferenceDataSourceDescription").add("BucketARN", (Object)this.bucketARN()).add("FileKey", (Object)this.fileKey()).add("ReferenceRoleARN", (Object)this.referenceRoleARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketARN": {
                return Optional.ofNullable(clazz.cast(this.bucketARN()));
            }
            case "FileKey": {
                return Optional.ofNullable(clazz.cast(this.fileKey()));
            }
            case "ReferenceRoleARN": {
                return Optional.ofNullable(clazz.cast(this.referenceRoleARN()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ReferenceDataSourceDescription, T> g) {
        return obj -> g.apply((S3ReferenceDataSourceDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketARN;
        private String fileKey;
        private String referenceRoleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ReferenceDataSourceDescription model) {
            this.bucketARN(model.bucketARN);
            this.fileKey(model.fileKey);
            this.referenceRoleARN(model.referenceRoleARN);
        }

        public final String getBucketARN() {
            return this.bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getFileKey() {
            return this.fileKey;
        }

        @Override
        public final Builder fileKey(String fileKey) {
            this.fileKey = fileKey;
            return this;
        }

        public final void setFileKey(String fileKey) {
            this.fileKey = fileKey;
        }

        public final String getReferenceRoleARN() {
            return this.referenceRoleARN;
        }

        @Override
        public final Builder referenceRoleARN(String referenceRoleARN) {
            this.referenceRoleARN = referenceRoleARN;
            return this;
        }

        public final void setReferenceRoleARN(String referenceRoleARN) {
            this.referenceRoleARN = referenceRoleARN;
        }

        public S3ReferenceDataSourceDescription build() {
            return new S3ReferenceDataSourceDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ReferenceDataSourceDescription> {
        public Builder bucketARN(String var1);

        public Builder fileKey(String var1);

        public Builder referenceRoleARN(String var1);
    }
}

