/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationRestoreConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationRestoreConfiguration> {
    private static final SdkField<String> APPLICATION_RESTORE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationRestoreConfiguration.getter(ApplicationRestoreConfiguration::applicationRestoreTypeAsString)).setter(ApplicationRestoreConfiguration.setter(Builder::applicationRestoreType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationRestoreType").build()}).build();
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationRestoreConfiguration.getter(ApplicationRestoreConfiguration::snapshotName)).setter(ApplicationRestoreConfiguration.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_RESTORE_TYPE_FIELD, SNAPSHOT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationRestoreType;
    private final String snapshotName;

    private ApplicationRestoreConfiguration(BuilderImpl builder) {
        this.applicationRestoreType = builder.applicationRestoreType;
        this.snapshotName = builder.snapshotName;
    }

    public ApplicationRestoreType applicationRestoreType() {
        return ApplicationRestoreType.fromValue(this.applicationRestoreType);
    }

    public String applicationRestoreTypeAsString() {
        return this.applicationRestoreType;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationRestoreTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationRestoreConfiguration)) {
            return false;
        }
        ApplicationRestoreConfiguration other = (ApplicationRestoreConfiguration)obj;
        return Objects.equals(this.applicationRestoreTypeAsString(), other.applicationRestoreTypeAsString()) && Objects.equals(this.snapshotName(), other.snapshotName());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationRestoreConfiguration").add("ApplicationRestoreType", (Object)this.applicationRestoreTypeAsString()).add("SnapshotName", (Object)this.snapshotName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationRestoreType": {
                return Optional.ofNullable(clazz.cast(this.applicationRestoreTypeAsString()));
            }
            case "SnapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationRestoreConfiguration, T> g) {
        return obj -> g.apply((ApplicationRestoreConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationRestoreType;
        private String snapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationRestoreConfiguration model) {
            this.applicationRestoreType(model.applicationRestoreType);
            this.snapshotName(model.snapshotName);
        }

        public final String getApplicationRestoreTypeAsString() {
            return this.applicationRestoreType;
        }

        @Override
        public final Builder applicationRestoreType(String applicationRestoreType) {
            this.applicationRestoreType = applicationRestoreType;
            return this;
        }

        @Override
        public final Builder applicationRestoreType(ApplicationRestoreType applicationRestoreType) {
            this.applicationRestoreType(applicationRestoreType.toString());
            return this;
        }

        public final void setApplicationRestoreType(String applicationRestoreType) {
            this.applicationRestoreType = applicationRestoreType;
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        public ApplicationRestoreConfiguration build() {
            return new ApplicationRestoreConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationRestoreConfiguration> {
        public Builder applicationRestoreType(String var1);

        public Builder applicationRestoreType(ApplicationRestoreType var1);

        public Builder snapshotName(String var1);
    }
}

