/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ArtifactType;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.MavenReference;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomArtifactConfigurationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomArtifactConfigurationDescription> {
    private static final SdkField<String> ARTIFACT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactType").getter(CustomArtifactConfigurationDescription.getter(CustomArtifactConfigurationDescription::artifactTypeAsString)).setter(CustomArtifactConfigurationDescription.setter(Builder::artifactType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactType").build()}).build();
    private static final SdkField<S3ContentLocation> S3_CONTENT_LOCATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3ContentLocationDescription").getter(CustomArtifactConfigurationDescription.getter(CustomArtifactConfigurationDescription::s3ContentLocationDescription)).setter(CustomArtifactConfigurationDescription.setter(Builder::s3ContentLocationDescription)).constructor(S3ContentLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ContentLocationDescription").build()}).build();
    private static final SdkField<MavenReference> MAVEN_REFERENCE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MavenReferenceDescription").getter(CustomArtifactConfigurationDescription.getter(CustomArtifactConfigurationDescription::mavenReferenceDescription)).setter(CustomArtifactConfigurationDescription.setter(Builder::mavenReferenceDescription)).constructor(MavenReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MavenReferenceDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_TYPE_FIELD, S3_CONTENT_LOCATION_DESCRIPTION_FIELD, MAVEN_REFERENCE_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomArtifactConfigurationDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String artifactType;
    private final S3ContentLocation s3ContentLocationDescription;
    private final MavenReference mavenReferenceDescription;

    private CustomArtifactConfigurationDescription(BuilderImpl builder) {
        this.artifactType = builder.artifactType;
        this.s3ContentLocationDescription = builder.s3ContentLocationDescription;
        this.mavenReferenceDescription = builder.mavenReferenceDescription;
    }

    public final ArtifactType artifactType() {
        return ArtifactType.fromValue(this.artifactType);
    }

    public final String artifactTypeAsString() {
        return this.artifactType;
    }

    public final S3ContentLocation s3ContentLocationDescription() {
        return this.s3ContentLocationDescription;
    }

    public final MavenReference mavenReferenceDescription() {
        return this.mavenReferenceDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ContentLocationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.mavenReferenceDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomArtifactConfigurationDescription)) {
            return false;
        }
        CustomArtifactConfigurationDescription other = (CustomArtifactConfigurationDescription)obj;
        return Objects.equals(this.artifactTypeAsString(), other.artifactTypeAsString()) && Objects.equals(this.s3ContentLocationDescription(), other.s3ContentLocationDescription()) && Objects.equals(this.mavenReferenceDescription(), other.mavenReferenceDescription());
    }

    public final String toString() {
        return ToString.builder((String)"CustomArtifactConfigurationDescription").add("ArtifactType", (Object)this.artifactTypeAsString()).add("S3ContentLocationDescription", (Object)this.s3ContentLocationDescription()).add("MavenReferenceDescription", (Object)this.mavenReferenceDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArtifactType": {
                return Optional.ofNullable(clazz.cast(this.artifactTypeAsString()));
            }
            case "S3ContentLocationDescription": {
                return Optional.ofNullable(clazz.cast(this.s3ContentLocationDescription()));
            }
            case "MavenReferenceDescription": {
                return Optional.ofNullable(clazz.cast(this.mavenReferenceDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ArtifactType", ARTIFACT_TYPE_FIELD);
        map.put("S3ContentLocationDescription", S3_CONTENT_LOCATION_DESCRIPTION_FIELD);
        map.put("MavenReferenceDescription", MAVEN_REFERENCE_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomArtifactConfigurationDescription, T> g) {
        return obj -> g.apply((CustomArtifactConfigurationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String artifactType;
        private S3ContentLocation s3ContentLocationDescription;
        private MavenReference mavenReferenceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomArtifactConfigurationDescription model) {
            this.artifactType(model.artifactType);
            this.s3ContentLocationDescription(model.s3ContentLocationDescription);
            this.mavenReferenceDescription(model.mavenReferenceDescription);
        }

        public final String getArtifactType() {
            return this.artifactType;
        }

        public final void setArtifactType(String artifactType) {
            this.artifactType = artifactType;
        }

        @Override
        public final Builder artifactType(String artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        @Override
        public final Builder artifactType(ArtifactType artifactType) {
            this.artifactType(artifactType == null ? null : artifactType.toString());
            return this;
        }

        public final S3ContentLocation.Builder getS3ContentLocationDescription() {
            return this.s3ContentLocationDescription != null ? this.s3ContentLocationDescription.toBuilder() : null;
        }

        public final void setS3ContentLocationDescription(S3ContentLocation.BuilderImpl s3ContentLocationDescription) {
            this.s3ContentLocationDescription = s3ContentLocationDescription != null ? s3ContentLocationDescription.build() : null;
        }

        @Override
        public final Builder s3ContentLocationDescription(S3ContentLocation s3ContentLocationDescription) {
            this.s3ContentLocationDescription = s3ContentLocationDescription;
            return this;
        }

        public final MavenReference.Builder getMavenReferenceDescription() {
            return this.mavenReferenceDescription != null ? this.mavenReferenceDescription.toBuilder() : null;
        }

        public final void setMavenReferenceDescription(MavenReference.BuilderImpl mavenReferenceDescription) {
            this.mavenReferenceDescription = mavenReferenceDescription != null ? mavenReferenceDescription.build() : null;
        }

        @Override
        public final Builder mavenReferenceDescription(MavenReference mavenReferenceDescription) {
            this.mavenReferenceDescription = mavenReferenceDescription;
            return this;
        }

        public CustomArtifactConfigurationDescription build() {
            return new CustomArtifactConfigurationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomArtifactConfigurationDescription> {
        public Builder artifactType(String var1);

        public Builder artifactType(ArtifactType var1);

        public Builder s3ContentLocationDescription(S3ContentLocation var1);

        default public Builder s3ContentLocationDescription(Consumer<S3ContentLocation.Builder> s3ContentLocationDescription) {
            return this.s3ContentLocationDescription((S3ContentLocation)((S3ContentLocation.Builder)S3ContentLocation.builder().applyMutation(s3ContentLocationDescription)).build());
        }

        public Builder mavenReferenceDescription(MavenReference var1);

        default public Builder mavenReferenceDescription(Consumer<MavenReference.Builder> mavenReferenceDescription) {
            return this.mavenReferenceDescription((MavenReference)((MavenReference.Builder)MavenReference.builder().applyMutation(mavenReferenceDescription)).build());
        }
    }
}

