/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InputParallelism;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInput;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInput;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SourceSchema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Input
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Input> {
    private static final SdkField<String> NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NamePrefix").getter(Input.getter(Input::namePrefix)).setter(Input.setter(Builder::namePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamePrefix").build()}).build();
    private static final SdkField<InputProcessingConfiguration> INPUT_PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputProcessingConfiguration").getter(Input.getter(Input::inputProcessingConfiguration)).setter(Input.setter(Builder::inputProcessingConfiguration)).constructor(InputProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputProcessingConfiguration").build()}).build();
    private static final SdkField<KinesisStreamsInput> KINESIS_STREAMS_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisStreamsInput").getter(Input.getter(Input::kinesisStreamsInput)).setter(Input.setter(Builder::kinesisStreamsInput)).constructor(KinesisStreamsInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamsInput").build()}).build();
    private static final SdkField<KinesisFirehoseInput> KINESIS_FIREHOSE_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisFirehoseInput").getter(Input.getter(Input::kinesisFirehoseInput)).setter(Input.setter(Builder::kinesisFirehoseInput)).constructor(KinesisFirehoseInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseInput").build()}).build();
    private static final SdkField<InputParallelism> INPUT_PARALLELISM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputParallelism").getter(Input.getter(Input::inputParallelism)).setter(Input.setter(Builder::inputParallelism)).constructor(InputParallelism::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputParallelism").build()}).build();
    private static final SdkField<SourceSchema> INPUT_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputSchema").getter(Input.getter(Input::inputSchema)).setter(Input.setter(Builder::inputSchema)).constructor(SourceSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputSchema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_PREFIX_FIELD, INPUT_PROCESSING_CONFIGURATION_FIELD, KINESIS_STREAMS_INPUT_FIELD, KINESIS_FIREHOSE_INPUT_FIELD, INPUT_PARALLELISM_FIELD, INPUT_SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Input.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String namePrefix;
    private final InputProcessingConfiguration inputProcessingConfiguration;
    private final KinesisStreamsInput kinesisStreamsInput;
    private final KinesisFirehoseInput kinesisFirehoseInput;
    private final InputParallelism inputParallelism;
    private final SourceSchema inputSchema;

    private Input(BuilderImpl builder) {
        this.namePrefix = builder.namePrefix;
        this.inputProcessingConfiguration = builder.inputProcessingConfiguration;
        this.kinesisStreamsInput = builder.kinesisStreamsInput;
        this.kinesisFirehoseInput = builder.kinesisFirehoseInput;
        this.inputParallelism = builder.inputParallelism;
        this.inputSchema = builder.inputSchema;
    }

    public final String namePrefix() {
        return this.namePrefix;
    }

    public final InputProcessingConfiguration inputProcessingConfiguration() {
        return this.inputProcessingConfiguration;
    }

    public final KinesisStreamsInput kinesisStreamsInput() {
        return this.kinesisStreamsInput;
    }

    public final KinesisFirehoseInput kinesisFirehoseInput() {
        return this.kinesisFirehoseInput;
    }

    public final InputParallelism inputParallelism() {
        return this.inputParallelism;
    }

    public final SourceSchema inputSchema() {
        return this.inputSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputProcessingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamsInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputParallelism());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSchema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input)obj;
        return Objects.equals(this.namePrefix(), other.namePrefix()) && Objects.equals(this.inputProcessingConfiguration(), other.inputProcessingConfiguration()) && Objects.equals(this.kinesisStreamsInput(), other.kinesisStreamsInput()) && Objects.equals(this.kinesisFirehoseInput(), other.kinesisFirehoseInput()) && Objects.equals(this.inputParallelism(), other.inputParallelism()) && Objects.equals(this.inputSchema(), other.inputSchema());
    }

    public final String toString() {
        return ToString.builder((String)"Input").add("NamePrefix", (Object)this.namePrefix()).add("InputProcessingConfiguration", (Object)this.inputProcessingConfiguration()).add("KinesisStreamsInput", (Object)this.kinesisStreamsInput()).add("KinesisFirehoseInput", (Object)this.kinesisFirehoseInput()).add("InputParallelism", (Object)this.inputParallelism()).add("InputSchema", (Object)this.inputSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamePrefix": {
                return Optional.ofNullable(clazz.cast(this.namePrefix()));
            }
            case "InputProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputProcessingConfiguration()));
            }
            case "KinesisStreamsInput": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamsInput()));
            }
            case "KinesisFirehoseInput": {
                return Optional.ofNullable(clazz.cast(this.kinesisFirehoseInput()));
            }
            case "InputParallelism": {
                return Optional.ofNullable(clazz.cast(this.inputParallelism()));
            }
            case "InputSchema": {
                return Optional.ofNullable(clazz.cast(this.inputSchema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NamePrefix", NAME_PREFIX_FIELD);
        map.put("InputProcessingConfiguration", INPUT_PROCESSING_CONFIGURATION_FIELD);
        map.put("KinesisStreamsInput", KINESIS_STREAMS_INPUT_FIELD);
        map.put("KinesisFirehoseInput", KINESIS_FIREHOSE_INPUT_FIELD);
        map.put("InputParallelism", INPUT_PARALLELISM_FIELD);
        map.put("InputSchema", INPUT_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Input, T> g) {
        return obj -> g.apply((Input)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namePrefix;
        private InputProcessingConfiguration inputProcessingConfiguration;
        private KinesisStreamsInput kinesisStreamsInput;
        private KinesisFirehoseInput kinesisFirehoseInput;
        private InputParallelism inputParallelism;
        private SourceSchema inputSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            this.namePrefix(model.namePrefix);
            this.inputProcessingConfiguration(model.inputProcessingConfiguration);
            this.kinesisStreamsInput(model.kinesisStreamsInput);
            this.kinesisFirehoseInput(model.kinesisFirehoseInput);
            this.inputParallelism(model.inputParallelism);
            this.inputSchema(model.inputSchema);
        }

        public final String getNamePrefix() {
            return this.namePrefix;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final InputProcessingConfiguration.Builder getInputProcessingConfiguration() {
            return this.inputProcessingConfiguration != null ? this.inputProcessingConfiguration.toBuilder() : null;
        }

        public final void setInputProcessingConfiguration(InputProcessingConfiguration.BuilderImpl inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration != null ? inputProcessingConfiguration.build() : null;
        }

        @Override
        public final Builder inputProcessingConfiguration(InputProcessingConfiguration inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration;
            return this;
        }

        public final KinesisStreamsInput.Builder getKinesisStreamsInput() {
            return this.kinesisStreamsInput != null ? this.kinesisStreamsInput.toBuilder() : null;
        }

        public final void setKinesisStreamsInput(KinesisStreamsInput.BuilderImpl kinesisStreamsInput) {
            this.kinesisStreamsInput = kinesisStreamsInput != null ? kinesisStreamsInput.build() : null;
        }

        @Override
        public final Builder kinesisStreamsInput(KinesisStreamsInput kinesisStreamsInput) {
            this.kinesisStreamsInput = kinesisStreamsInput;
            return this;
        }

        public final KinesisFirehoseInput.Builder getKinesisFirehoseInput() {
            return this.kinesisFirehoseInput != null ? this.kinesisFirehoseInput.toBuilder() : null;
        }

        public final void setKinesisFirehoseInput(KinesisFirehoseInput.BuilderImpl kinesisFirehoseInput) {
            this.kinesisFirehoseInput = kinesisFirehoseInput != null ? kinesisFirehoseInput.build() : null;
        }

        @Override
        public final Builder kinesisFirehoseInput(KinesisFirehoseInput kinesisFirehoseInput) {
            this.kinesisFirehoseInput = kinesisFirehoseInput;
            return this;
        }

        public final InputParallelism.Builder getInputParallelism() {
            return this.inputParallelism != null ? this.inputParallelism.toBuilder() : null;
        }

        public final void setInputParallelism(InputParallelism.BuilderImpl inputParallelism) {
            this.inputParallelism = inputParallelism != null ? inputParallelism.build() : null;
        }

        @Override
        public final Builder inputParallelism(InputParallelism inputParallelism) {
            this.inputParallelism = inputParallelism;
            return this;
        }

        public final SourceSchema.Builder getInputSchema() {
            return this.inputSchema != null ? this.inputSchema.toBuilder() : null;
        }

        public final void setInputSchema(SourceSchema.BuilderImpl inputSchema) {
            this.inputSchema = inputSchema != null ? inputSchema.build() : null;
        }

        @Override
        public final Builder inputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public Input build() {
            return new Input(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Input> {
        public Builder namePrefix(String var1);

        public Builder inputProcessingConfiguration(InputProcessingConfiguration var1);

        default public Builder inputProcessingConfiguration(Consumer<InputProcessingConfiguration.Builder> inputProcessingConfiguration) {
            return this.inputProcessingConfiguration((InputProcessingConfiguration)((InputProcessingConfiguration.Builder)InputProcessingConfiguration.builder().applyMutation(inputProcessingConfiguration)).build());
        }

        public Builder kinesisStreamsInput(KinesisStreamsInput var1);

        default public Builder kinesisStreamsInput(Consumer<KinesisStreamsInput.Builder> kinesisStreamsInput) {
            return this.kinesisStreamsInput((KinesisStreamsInput)((KinesisStreamsInput.Builder)KinesisStreamsInput.builder().applyMutation(kinesisStreamsInput)).build());
        }

        public Builder kinesisFirehoseInput(KinesisFirehoseInput var1);

        default public Builder kinesisFirehoseInput(Consumer<KinesisFirehoseInput.Builder> kinesisFirehoseInput) {
            return this.kinesisFirehoseInput((KinesisFirehoseInput)((KinesisFirehoseInput.Builder)KinesisFirehoseInput.builder().applyMutation(kinesisFirehoseInput)).build());
        }

        public Builder inputParallelism(InputParallelism var1);

        default public Builder inputParallelism(Consumer<InputParallelism.Builder> inputParallelism) {
            return this.inputParallelism((InputParallelism)((InputParallelism.Builder)InputParallelism.builder().applyMutation(inputParallelism)).build());
        }

        public Builder inputSchema(SourceSchema var1);

        default public Builder inputSchema(Consumer<SourceSchema.Builder> inputSchema) {
            return this.inputSchema((SourceSchema)((SourceSchema.Builder)SourceSchema.builder().applyMutation(inputSchema)).build());
        }
    }
}

