/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DestinationSchema;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseOutputDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsOutputDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.LambdaOutputDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputDescription> {
    private static final SdkField<String> OUTPUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputId").getter(OutputDescription.getter(OutputDescription::outputId)).setter(OutputDescription.setter(Builder::outputId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(OutputDescription.getter(OutputDescription::name)).setter(OutputDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<KinesisStreamsOutputDescription> KINESIS_STREAMS_OUTPUT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisStreamsOutputDescription").getter(OutputDescription.getter(OutputDescription::kinesisStreamsOutputDescription)).setter(OutputDescription.setter(Builder::kinesisStreamsOutputDescription)).constructor(KinesisStreamsOutputDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamsOutputDescription").build()}).build();
    private static final SdkField<KinesisFirehoseOutputDescription> KINESIS_FIREHOSE_OUTPUT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisFirehoseOutputDescription").getter(OutputDescription.getter(OutputDescription::kinesisFirehoseOutputDescription)).setter(OutputDescription.setter(Builder::kinesisFirehoseOutputDescription)).constructor(KinesisFirehoseOutputDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseOutputDescription").build()}).build();
    private static final SdkField<LambdaOutputDescription> LAMBDA_OUTPUT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LambdaOutputDescription").getter(OutputDescription.getter(OutputDescription::lambdaOutputDescription)).setter(OutputDescription.setter(Builder::lambdaOutputDescription)).constructor(LambdaOutputDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaOutputDescription").build()}).build();
    private static final SdkField<DestinationSchema> DESTINATION_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationSchema").getter(OutputDescription.getter(OutputDescription::destinationSchema)).setter(OutputDescription.setter(Builder::destinationSchema)).constructor(DestinationSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSchema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_ID_FIELD, NAME_FIELD, KINESIS_STREAMS_OUTPUT_DESCRIPTION_FIELD, KINESIS_FIREHOSE_OUTPUT_DESCRIPTION_FIELD, LAMBDA_OUTPUT_DESCRIPTION_FIELD, DESTINATION_SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OutputDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String outputId;
    private final String name;
    private final KinesisStreamsOutputDescription kinesisStreamsOutputDescription;
    private final KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription;
    private final LambdaOutputDescription lambdaOutputDescription;
    private final DestinationSchema destinationSchema;

    private OutputDescription(BuilderImpl builder) {
        this.outputId = builder.outputId;
        this.name = builder.name;
        this.kinesisStreamsOutputDescription = builder.kinesisStreamsOutputDescription;
        this.kinesisFirehoseOutputDescription = builder.kinesisFirehoseOutputDescription;
        this.lambdaOutputDescription = builder.lambdaOutputDescription;
        this.destinationSchema = builder.destinationSchema;
    }

    public final String outputId() {
        return this.outputId;
    }

    public final String name() {
        return this.name;
    }

    public final KinesisStreamsOutputDescription kinesisStreamsOutputDescription() {
        return this.kinesisStreamsOutputDescription;
    }

    public final KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription() {
        return this.kinesisFirehoseOutputDescription;
    }

    public final LambdaOutputDescription lambdaOutputDescription() {
        return this.lambdaOutputDescription;
    }

    public final DestinationSchema destinationSchema() {
        return this.destinationSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamsOutputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseOutputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaOutputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSchema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDescription)) {
            return false;
        }
        OutputDescription other = (OutputDescription)obj;
        return Objects.equals(this.outputId(), other.outputId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.kinesisStreamsOutputDescription(), other.kinesisStreamsOutputDescription()) && Objects.equals(this.kinesisFirehoseOutputDescription(), other.kinesisFirehoseOutputDescription()) && Objects.equals(this.lambdaOutputDescription(), other.lambdaOutputDescription()) && Objects.equals(this.destinationSchema(), other.destinationSchema());
    }

    public final String toString() {
        return ToString.builder((String)"OutputDescription").add("OutputId", (Object)this.outputId()).add("Name", (Object)this.name()).add("KinesisStreamsOutputDescription", (Object)this.kinesisStreamsOutputDescription()).add("KinesisFirehoseOutputDescription", (Object)this.kinesisFirehoseOutputDescription()).add("LambdaOutputDescription", (Object)this.lambdaOutputDescription()).add("DestinationSchema", (Object)this.destinationSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputId": {
                return Optional.ofNullable(clazz.cast(this.outputId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "KinesisStreamsOutputDescription": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamsOutputDescription()));
            }
            case "KinesisFirehoseOutputDescription": {
                return Optional.ofNullable(clazz.cast(this.kinesisFirehoseOutputDescription()));
            }
            case "LambdaOutputDescription": {
                return Optional.ofNullable(clazz.cast(this.lambdaOutputDescription()));
            }
            case "DestinationSchema": {
                return Optional.ofNullable(clazz.cast(this.destinationSchema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OutputId", OUTPUT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("KinesisStreamsOutputDescription", KINESIS_STREAMS_OUTPUT_DESCRIPTION_FIELD);
        map.put("KinesisFirehoseOutputDescription", KINESIS_FIREHOSE_OUTPUT_DESCRIPTION_FIELD);
        map.put("LambdaOutputDescription", LAMBDA_OUTPUT_DESCRIPTION_FIELD);
        map.put("DestinationSchema", DESTINATION_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutputDescription, T> g) {
        return obj -> g.apply((OutputDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputId;
        private String name;
        private KinesisStreamsOutputDescription kinesisStreamsOutputDescription;
        private KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription;
        private LambdaOutputDescription lambdaOutputDescription;
        private DestinationSchema destinationSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDescription model) {
            this.outputId(model.outputId);
            this.name(model.name);
            this.kinesisStreamsOutputDescription(model.kinesisStreamsOutputDescription);
            this.kinesisFirehoseOutputDescription(model.kinesisFirehoseOutputDescription);
            this.lambdaOutputDescription(model.lambdaOutputDescription);
            this.destinationSchema(model.destinationSchema);
        }

        public final String getOutputId() {
            return this.outputId;
        }

        public final void setOutputId(String outputId) {
            this.outputId = outputId;
        }

        @Override
        public final Builder outputId(String outputId) {
            this.outputId = outputId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final KinesisStreamsOutputDescription.Builder getKinesisStreamsOutputDescription() {
            return this.kinesisStreamsOutputDescription != null ? this.kinesisStreamsOutputDescription.toBuilder() : null;
        }

        public final void setKinesisStreamsOutputDescription(KinesisStreamsOutputDescription.BuilderImpl kinesisStreamsOutputDescription) {
            this.kinesisStreamsOutputDescription = kinesisStreamsOutputDescription != null ? kinesisStreamsOutputDescription.build() : null;
        }

        @Override
        public final Builder kinesisStreamsOutputDescription(KinesisStreamsOutputDescription kinesisStreamsOutputDescription) {
            this.kinesisStreamsOutputDescription = kinesisStreamsOutputDescription;
            return this;
        }

        public final KinesisFirehoseOutputDescription.Builder getKinesisFirehoseOutputDescription() {
            return this.kinesisFirehoseOutputDescription != null ? this.kinesisFirehoseOutputDescription.toBuilder() : null;
        }

        public final void setKinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription.BuilderImpl kinesisFirehoseOutputDescription) {
            this.kinesisFirehoseOutputDescription = kinesisFirehoseOutputDescription != null ? kinesisFirehoseOutputDescription.build() : null;
        }

        @Override
        public final Builder kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription) {
            this.kinesisFirehoseOutputDescription = kinesisFirehoseOutputDescription;
            return this;
        }

        public final LambdaOutputDescription.Builder getLambdaOutputDescription() {
            return this.lambdaOutputDescription != null ? this.lambdaOutputDescription.toBuilder() : null;
        }

        public final void setLambdaOutputDescription(LambdaOutputDescription.BuilderImpl lambdaOutputDescription) {
            this.lambdaOutputDescription = lambdaOutputDescription != null ? lambdaOutputDescription.build() : null;
        }

        @Override
        public final Builder lambdaOutputDescription(LambdaOutputDescription lambdaOutputDescription) {
            this.lambdaOutputDescription = lambdaOutputDescription;
            return this;
        }

        public final DestinationSchema.Builder getDestinationSchema() {
            return this.destinationSchema != null ? this.destinationSchema.toBuilder() : null;
        }

        public final void setDestinationSchema(DestinationSchema.BuilderImpl destinationSchema) {
            this.destinationSchema = destinationSchema != null ? destinationSchema.build() : null;
        }

        @Override
        public final Builder destinationSchema(DestinationSchema destinationSchema) {
            this.destinationSchema = destinationSchema;
            return this;
        }

        public OutputDescription build() {
            return new OutputDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputDescription> {
        public Builder outputId(String var1);

        public Builder name(String var1);

        public Builder kinesisStreamsOutputDescription(KinesisStreamsOutputDescription var1);

        default public Builder kinesisStreamsOutputDescription(Consumer<KinesisStreamsOutputDescription.Builder> kinesisStreamsOutputDescription) {
            return this.kinesisStreamsOutputDescription((KinesisStreamsOutputDescription)((KinesisStreamsOutputDescription.Builder)KinesisStreamsOutputDescription.builder().applyMutation(kinesisStreamsOutputDescription)).build());
        }

        public Builder kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription var1);

        default public Builder kinesisFirehoseOutputDescription(Consumer<KinesisFirehoseOutputDescription.Builder> kinesisFirehoseOutputDescription) {
            return this.kinesisFirehoseOutputDescription((KinesisFirehoseOutputDescription)((KinesisFirehoseOutputDescription.Builder)KinesisFirehoseOutputDescription.builder().applyMutation(kinesisFirehoseOutputDescription)).build());
        }

        public Builder lambdaOutputDescription(LambdaOutputDescription var1);

        default public Builder lambdaOutputDescription(Consumer<LambdaOutputDescription.Builder> lambdaOutputDescription) {
            return this.lambdaOutputDescription((LambdaOutputDescription)((LambdaOutputDescription.Builder)LambdaOutputDescription.builder().applyMutation(lambdaOutputDescription)).build());
        }

        public Builder destinationSchema(DestinationSchema var1);

        default public Builder destinationSchema(Consumer<DestinationSchema.Builder> destinationSchema) {
            return this.destinationSchema((DestinationSchema)((DestinationSchema.Builder)DestinationSchema.builder().applyMutation(destinationSchema)).build());
        }
    }
}

