/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ArtifactType;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.MavenReference;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomArtifactConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomArtifactConfiguration> {
    private static final SdkField<String> ARTIFACT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactType").getter(CustomArtifactConfiguration.getter(CustomArtifactConfiguration::artifactTypeAsString)).setter(CustomArtifactConfiguration.setter(Builder::artifactType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactType").build()}).build();
    private static final SdkField<S3ContentLocation> S3_CONTENT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3ContentLocation").getter(CustomArtifactConfiguration.getter(CustomArtifactConfiguration::s3ContentLocation)).setter(CustomArtifactConfiguration.setter(Builder::s3ContentLocation)).constructor(S3ContentLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ContentLocation").build()}).build();
    private static final SdkField<MavenReference> MAVEN_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MavenReference").getter(CustomArtifactConfiguration.getter(CustomArtifactConfiguration::mavenReference)).setter(CustomArtifactConfiguration.setter(Builder::mavenReference)).constructor(MavenReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MavenReference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_TYPE_FIELD, S3_CONTENT_LOCATION_FIELD, MAVEN_REFERENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomArtifactConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String artifactType;
    private final S3ContentLocation s3ContentLocation;
    private final MavenReference mavenReference;

    private CustomArtifactConfiguration(BuilderImpl builder) {
        this.artifactType = builder.artifactType;
        this.s3ContentLocation = builder.s3ContentLocation;
        this.mavenReference = builder.mavenReference;
    }

    public final ArtifactType artifactType() {
        return ArtifactType.fromValue(this.artifactType);
    }

    public final String artifactTypeAsString() {
        return this.artifactType;
    }

    public final S3ContentLocation s3ContentLocation() {
        return this.s3ContentLocation;
    }

    public final MavenReference mavenReference() {
        return this.mavenReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ContentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.mavenReference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomArtifactConfiguration)) {
            return false;
        }
        CustomArtifactConfiguration other = (CustomArtifactConfiguration)obj;
        return Objects.equals(this.artifactTypeAsString(), other.artifactTypeAsString()) && Objects.equals(this.s3ContentLocation(), other.s3ContentLocation()) && Objects.equals(this.mavenReference(), other.mavenReference());
    }

    public final String toString() {
        return ToString.builder((String)"CustomArtifactConfiguration").add("ArtifactType", (Object)this.artifactTypeAsString()).add("S3ContentLocation", (Object)this.s3ContentLocation()).add("MavenReference", (Object)this.mavenReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArtifactType": {
                return Optional.ofNullable(clazz.cast(this.artifactTypeAsString()));
            }
            case "S3ContentLocation": {
                return Optional.ofNullable(clazz.cast(this.s3ContentLocation()));
            }
            case "MavenReference": {
                return Optional.ofNullable(clazz.cast(this.mavenReference()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ArtifactType", ARTIFACT_TYPE_FIELD);
        map.put("S3ContentLocation", S3_CONTENT_LOCATION_FIELD);
        map.put("MavenReference", MAVEN_REFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomArtifactConfiguration, T> g) {
        return obj -> g.apply((CustomArtifactConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String artifactType;
        private S3ContentLocation s3ContentLocation;
        private MavenReference mavenReference;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomArtifactConfiguration model) {
            this.artifactType(model.artifactType);
            this.s3ContentLocation(model.s3ContentLocation);
            this.mavenReference(model.mavenReference);
        }

        public final String getArtifactType() {
            return this.artifactType;
        }

        public final void setArtifactType(String artifactType) {
            this.artifactType = artifactType;
        }

        @Override
        public final Builder artifactType(String artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        @Override
        public final Builder artifactType(ArtifactType artifactType) {
            this.artifactType(artifactType == null ? null : artifactType.toString());
            return this;
        }

        public final S3ContentLocation.Builder getS3ContentLocation() {
            return this.s3ContentLocation != null ? this.s3ContentLocation.toBuilder() : null;
        }

        public final void setS3ContentLocation(S3ContentLocation.BuilderImpl s3ContentLocation) {
            this.s3ContentLocation = s3ContentLocation != null ? s3ContentLocation.build() : null;
        }

        @Override
        public final Builder s3ContentLocation(S3ContentLocation s3ContentLocation) {
            this.s3ContentLocation = s3ContentLocation;
            return this;
        }

        public final MavenReference.Builder getMavenReference() {
            return this.mavenReference != null ? this.mavenReference.toBuilder() : null;
        }

        public final void setMavenReference(MavenReference.BuilderImpl mavenReference) {
            this.mavenReference = mavenReference != null ? mavenReference.build() : null;
        }

        @Override
        public final Builder mavenReference(MavenReference mavenReference) {
            this.mavenReference = mavenReference;
            return this;
        }

        public CustomArtifactConfiguration build() {
            return new CustomArtifactConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomArtifactConfiguration> {
        public Builder artifactType(String var1);

        public Builder artifactType(ArtifactType var1);

        public Builder s3ContentLocation(S3ContentLocation var1);

        default public Builder s3ContentLocation(Consumer<S3ContentLocation.Builder> s3ContentLocation) {
            return this.s3ContentLocation((S3ContentLocation)((S3ContentLocation.Builder)S3ContentLocation.builder().applyMutation(s3ContentLocation)).build());
        }

        public Builder mavenReference(MavenReference var1);

        default public Builder mavenReference(Consumer<MavenReference.Builder> mavenReference) {
            return this.mavenReference((MavenReference)((MavenReference.Builder)MavenReference.builder().applyMutation(mavenReference)).build());
        }
    }
}

