/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ArtifactType {
    UDF("UDF"),
    DEPENDENCY_JAR("DEPENDENCY_JAR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ArtifactType> VALUE_MAP;
    private final String value;

    private ArtifactType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ArtifactType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ArtifactType> knownValues() {
        EnumSet<ArtifactType> knownValues = EnumSet.allOf(ArtifactType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ArtifactType.class, ArtifactType::toString);
    }
}

