/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationVersionChangeDetails;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.OperationFailureDetails;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.OperationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationOperationInfoDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationOperationInfoDetails> {
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(ApplicationOperationInfoDetails.getter(ApplicationOperationInfoDetails::operation)).setter(ApplicationOperationInfoDetails.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ApplicationOperationInfoDetails.getter(ApplicationOperationInfoDetails::startTime)).setter(ApplicationOperationInfoDetails.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ApplicationOperationInfoDetails.getter(ApplicationOperationInfoDetails::endTime)).setter(ApplicationOperationInfoDetails.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> OPERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationStatus").getter(ApplicationOperationInfoDetails.getter(ApplicationOperationInfoDetails::operationStatusAsString)).setter(ApplicationOperationInfoDetails.setter(Builder::operationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationStatus").build()}).build();
    private static final SdkField<ApplicationVersionChangeDetails> APPLICATION_VERSION_CHANGE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationVersionChangeDetails").getter(ApplicationOperationInfoDetails.getter(ApplicationOperationInfoDetails::applicationVersionChangeDetails)).setter(ApplicationOperationInfoDetails.setter(Builder::applicationVersionChangeDetails)).constructor(ApplicationVersionChangeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionChangeDetails").build()}).build();
    private static final SdkField<OperationFailureDetails> OPERATION_FAILURE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OperationFailureDetails").getter(ApplicationOperationInfoDetails.getter(ApplicationOperationInfoDetails::operationFailureDetails)).setter(ApplicationOperationInfoDetails.setter(Builder::operationFailureDetails)).constructor(OperationFailureDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationFailureDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_FIELD, START_TIME_FIELD, END_TIME_FIELD, OPERATION_STATUS_FIELD, APPLICATION_VERSION_CHANGE_DETAILS_FIELD, OPERATION_FAILURE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationOperationInfoDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String operation;
    private final Instant startTime;
    private final Instant endTime;
    private final String operationStatus;
    private final ApplicationVersionChangeDetails applicationVersionChangeDetails;
    private final OperationFailureDetails operationFailureDetails;

    private ApplicationOperationInfoDetails(BuilderImpl builder) {
        this.operation = builder.operation;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.operationStatus = builder.operationStatus;
        this.applicationVersionChangeDetails = builder.applicationVersionChangeDetails;
        this.operationFailureDetails = builder.operationFailureDetails;
    }

    public final String operation() {
        return this.operation;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final OperationStatus operationStatus() {
        return OperationStatus.fromValue(this.operationStatus);
    }

    public final String operationStatusAsString() {
        return this.operationStatus;
    }

    public final ApplicationVersionChangeDetails applicationVersionChangeDetails() {
        return this.applicationVersionChangeDetails;
    }

    public final OperationFailureDetails operationFailureDetails() {
        return this.operationFailureDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionChangeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationFailureDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationOperationInfoDetails)) {
            return false;
        }
        ApplicationOperationInfoDetails other = (ApplicationOperationInfoDetails)obj;
        return Objects.equals(this.operation(), other.operation()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.operationStatusAsString(), other.operationStatusAsString()) && Objects.equals(this.applicationVersionChangeDetails(), other.applicationVersionChangeDetails()) && Objects.equals(this.operationFailureDetails(), other.operationFailureDetails());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationOperationInfoDetails").add("Operation", (Object)this.operation()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("OperationStatus", (Object)this.operationStatusAsString()).add("ApplicationVersionChangeDetails", (Object)this.applicationVersionChangeDetails()).add("OperationFailureDetails", (Object)this.operationFailureDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "OperationStatus": {
                return Optional.ofNullable(clazz.cast(this.operationStatusAsString()));
            }
            case "ApplicationVersionChangeDetails": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionChangeDetails()));
            }
            case "OperationFailureDetails": {
                return Optional.ofNullable(clazz.cast(this.operationFailureDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Operation", OPERATION_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("OperationStatus", OPERATION_STATUS_FIELD);
        map.put("ApplicationVersionChangeDetails", APPLICATION_VERSION_CHANGE_DETAILS_FIELD);
        map.put("OperationFailureDetails", OPERATION_FAILURE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationOperationInfoDetails, T> g) {
        return obj -> g.apply((ApplicationOperationInfoDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operation;
        private Instant startTime;
        private Instant endTime;
        private String operationStatus;
        private ApplicationVersionChangeDetails applicationVersionChangeDetails;
        private OperationFailureDetails operationFailureDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationOperationInfoDetails model) {
            this.operation(model.operation);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.operationStatus(model.operationStatus);
            this.applicationVersionChangeDetails(model.applicationVersionChangeDetails);
            this.operationFailureDetails(model.operationFailureDetails);
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getOperationStatus() {
            return this.operationStatus;
        }

        public final void setOperationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
        }

        @Override
        public final Builder operationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
            return this;
        }

        @Override
        public final Builder operationStatus(OperationStatus operationStatus) {
            this.operationStatus(operationStatus == null ? null : operationStatus.toString());
            return this;
        }

        public final ApplicationVersionChangeDetails.Builder getApplicationVersionChangeDetails() {
            return this.applicationVersionChangeDetails != null ? this.applicationVersionChangeDetails.toBuilder() : null;
        }

        public final void setApplicationVersionChangeDetails(ApplicationVersionChangeDetails.BuilderImpl applicationVersionChangeDetails) {
            this.applicationVersionChangeDetails = applicationVersionChangeDetails != null ? applicationVersionChangeDetails.build() : null;
        }

        @Override
        public final Builder applicationVersionChangeDetails(ApplicationVersionChangeDetails applicationVersionChangeDetails) {
            this.applicationVersionChangeDetails = applicationVersionChangeDetails;
            return this;
        }

        public final OperationFailureDetails.Builder getOperationFailureDetails() {
            return this.operationFailureDetails != null ? this.operationFailureDetails.toBuilder() : null;
        }

        public final void setOperationFailureDetails(OperationFailureDetails.BuilderImpl operationFailureDetails) {
            this.operationFailureDetails = operationFailureDetails != null ? operationFailureDetails.build() : null;
        }

        @Override
        public final Builder operationFailureDetails(OperationFailureDetails operationFailureDetails) {
            this.operationFailureDetails = operationFailureDetails;
            return this;
        }

        public ApplicationOperationInfoDetails build() {
            return new ApplicationOperationInfoDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationOperationInfoDetails> {
        public Builder operation(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder operationStatus(String var1);

        public Builder operationStatus(OperationStatus var1);

        public Builder applicationVersionChangeDetails(ApplicationVersionChangeDetails var1);

        default public Builder applicationVersionChangeDetails(Consumer<ApplicationVersionChangeDetails.Builder> applicationVersionChangeDetails) {
            return this.applicationVersionChangeDetails((ApplicationVersionChangeDetails)((ApplicationVersionChangeDetails.Builder)ApplicationVersionChangeDetails.builder().applyMutation(applicationVersionChangeDetails)).build());
        }

        public Builder operationFailureDetails(OperationFailureDetails var1);

        default public Builder operationFailureDetails(Consumer<OperationFailureDetails.Builder> operationFailureDetails) {
            return this.operationFailureDetails((OperationFailureDetails)((OperationFailureDetails.Builder)OperationFailureDetails.builder().applyMutation(operationFailureDetails)).build());
        }
    }
}

