/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuntimeEnvironment {
    SQL_1_0("SQL-1_0"),
    FLINK_1_6("FLINK-1_6"),
    FLINK_1_8("FLINK-1_8"),
    ZEPPELIN_FLINK_1_0("ZEPPELIN-FLINK-1_0"),
    FLINK_1_11("FLINK-1_11"),
    FLINK_1_13("FLINK-1_13"),
    ZEPPELIN_FLINK_2_0("ZEPPELIN-FLINK-2_0"),
    FLINK_1_15("FLINK-1_15"),
    ZEPPELIN_FLINK_3_0("ZEPPELIN-FLINK-3_0"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuntimeEnvironment> VALUE_MAP;
    private final String value;

    private RuntimeEnvironment(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuntimeEnvironment fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuntimeEnvironment> knownValues() {
        EnumSet<RuntimeEnvironment> knownValues = EnumSet.allOf(RuntimeEnvironment.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuntimeEnvironment.class, RuntimeEnvironment::toString);
    }
}

