/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a Kinesis Data Analytics Studio notebook.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ZeppelinApplicationConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ZeppelinApplicationConfigurationDescription.Builder, ZeppelinApplicationConfigurationDescription> {
    private static final SdkField<ZeppelinMonitoringConfigurationDescription> MONITORING_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<ZeppelinMonitoringConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("MonitoringConfigurationDescription")
            .getter(getter(ZeppelinApplicationConfigurationDescription::monitoringConfigurationDescription))
            .setter(setter(Builder::monitoringConfigurationDescription))
            .constructor(ZeppelinMonitoringConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringConfigurationDescription")
                    .build()).build();

    private static final SdkField<CatalogConfigurationDescription> CATALOG_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<CatalogConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("CatalogConfigurationDescription")
            .getter(getter(ZeppelinApplicationConfigurationDescription::catalogConfigurationDescription))
            .setter(setter(Builder::catalogConfigurationDescription))
            .constructor(CatalogConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogConfigurationDescription")
                    .build()).build();

    private static final SdkField<DeployAsApplicationConfigurationDescription> DEPLOY_AS_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<DeployAsApplicationConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("DeployAsApplicationConfigurationDescription")
            .getter(getter(ZeppelinApplicationConfigurationDescription::deployAsApplicationConfigurationDescription))
            .setter(setter(Builder::deployAsApplicationConfigurationDescription))
            .constructor(DeployAsApplicationConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DeployAsApplicationConfigurationDescription").build()).build();

    private static final SdkField<List<CustomArtifactConfigurationDescription>> CUSTOM_ARTIFACTS_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<List<CustomArtifactConfigurationDescription>> builder(MarshallingType.LIST)
            .memberName("CustomArtifactsConfigurationDescription")
            .getter(getter(ZeppelinApplicationConfigurationDescription::customArtifactsConfigurationDescription))
            .setter(setter(Builder::customArtifactsConfigurationDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CustomArtifactsConfigurationDescription").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomArtifactConfigurationDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomArtifactConfigurationDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_CONFIGURATION_DESCRIPTION_FIELD, CATALOG_CONFIGURATION_DESCRIPTION_FIELD,
            DEPLOY_AS_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD, CUSTOM_ARTIFACTS_CONFIGURATION_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ZeppelinMonitoringConfigurationDescription monitoringConfigurationDescription;

    private final CatalogConfigurationDescription catalogConfigurationDescription;

    private final DeployAsApplicationConfigurationDescription deployAsApplicationConfigurationDescription;

    private final List<CustomArtifactConfigurationDescription> customArtifactsConfigurationDescription;

    private ZeppelinApplicationConfigurationDescription(BuilderImpl builder) {
        this.monitoringConfigurationDescription = builder.monitoringConfigurationDescription;
        this.catalogConfigurationDescription = builder.catalogConfigurationDescription;
        this.deployAsApplicationConfigurationDescription = builder.deployAsApplicationConfigurationDescription;
        this.customArtifactsConfigurationDescription = builder.customArtifactsConfigurationDescription;
    }

    /**
     * <p>
     * The monitoring configuration of a Kinesis Data Analytics Studio notebook.
     * </p>
     * 
     * @return The monitoring configuration of a Kinesis Data Analytics Studio notebook.
     */
    public final ZeppelinMonitoringConfigurationDescription monitoringConfigurationDescription() {
        return monitoringConfigurationDescription;
    }

    /**
     * <p>
     * The Amazon Glue Data Catalog that is associated with the Kinesis Data Analytics Studio notebook.
     * </p>
     * 
     * @return The Amazon Glue Data Catalog that is associated with the Kinesis Data Analytics Studio notebook.
     */
    public final CatalogConfigurationDescription catalogConfigurationDescription() {
        return catalogConfigurationDescription;
    }

    /**
     * <p>
     * The parameters required to deploy a Kinesis Data Analytics Studio notebook as an application with durable state.
     * </p>
     * 
     * @return The parameters required to deploy a Kinesis Data Analytics Studio notebook as an application with durable
     *         state.
     */
    public final DeployAsApplicationConfigurationDescription deployAsApplicationConfigurationDescription() {
        return deployAsApplicationConfigurationDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomArtifactsConfigurationDescription
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCustomArtifactsConfigurationDescription() {
        return customArtifactsConfigurationDescription != null
                && !(customArtifactsConfigurationDescription instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Custom artifacts are dependency JARs and user-defined functions (UDF).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasCustomArtifactsConfigurationDescription} method.
     * </p>
     * 
     * @return Custom artifacts are dependency JARs and user-defined functions (UDF).
     */
    public final List<CustomArtifactConfigurationDescription> customArtifactsConfigurationDescription() {
        return customArtifactsConfigurationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitoringConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(catalogConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(deployAsApplicationConfigurationDescription());
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasCustomArtifactsConfigurationDescription() ? customArtifactsConfigurationDescription()
                        : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZeppelinApplicationConfigurationDescription)) {
            return false;
        }
        ZeppelinApplicationConfigurationDescription other = (ZeppelinApplicationConfigurationDescription) obj;
        return Objects.equals(monitoringConfigurationDescription(), other.monitoringConfigurationDescription())
                && Objects.equals(catalogConfigurationDescription(), other.catalogConfigurationDescription())
                && Objects.equals(deployAsApplicationConfigurationDescription(),
                        other.deployAsApplicationConfigurationDescription())
                && hasCustomArtifactsConfigurationDescription() == other.hasCustomArtifactsConfigurationDescription()
                && Objects.equals(customArtifactsConfigurationDescription(), other.customArtifactsConfigurationDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ZeppelinApplicationConfigurationDescription")
                .add("MonitoringConfigurationDescription", monitoringConfigurationDescription())
                .add("CatalogConfigurationDescription", catalogConfigurationDescription())
                .add("DeployAsApplicationConfigurationDescription", deployAsApplicationConfigurationDescription())
                .add("CustomArtifactsConfigurationDescription",
                        hasCustomArtifactsConfigurationDescription() ? customArtifactsConfigurationDescription() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringConfigurationDescription":
            return Optional.ofNullable(clazz.cast(monitoringConfigurationDescription()));
        case "CatalogConfigurationDescription":
            return Optional.ofNullable(clazz.cast(catalogConfigurationDescription()));
        case "DeployAsApplicationConfigurationDescription":
            return Optional.ofNullable(clazz.cast(deployAsApplicationConfigurationDescription()));
        case "CustomArtifactsConfigurationDescription":
            return Optional.ofNullable(clazz.cast(customArtifactsConfigurationDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ZeppelinApplicationConfigurationDescription, T> g) {
        return obj -> g.apply((ZeppelinApplicationConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ZeppelinApplicationConfigurationDescription> {
        /**
         * <p>
         * The monitoring configuration of a Kinesis Data Analytics Studio notebook.
         * </p>
         * 
         * @param monitoringConfigurationDescription
         *        The monitoring configuration of a Kinesis Data Analytics Studio notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringConfigurationDescription(ZeppelinMonitoringConfigurationDescription monitoringConfigurationDescription);

        /**
         * <p>
         * The monitoring configuration of a Kinesis Data Analytics Studio notebook.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ZeppelinMonitoringConfigurationDescription.Builder} avoiding the need to create one manually via
         * {@link ZeppelinMonitoringConfigurationDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ZeppelinMonitoringConfigurationDescription.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #monitoringConfigurationDescription(ZeppelinMonitoringConfigurationDescription)}.
         * 
         * @param monitoringConfigurationDescription
         *        a consumer that will call methods on {@link ZeppelinMonitoringConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringConfigurationDescription(ZeppelinMonitoringConfigurationDescription)
         */
        default Builder monitoringConfigurationDescription(
                Consumer<ZeppelinMonitoringConfigurationDescription.Builder> monitoringConfigurationDescription) {
            return monitoringConfigurationDescription(ZeppelinMonitoringConfigurationDescription.builder()
                    .applyMutation(monitoringConfigurationDescription).build());
        }

        /**
         * <p>
         * The Amazon Glue Data Catalog that is associated with the Kinesis Data Analytics Studio notebook.
         * </p>
         * 
         * @param catalogConfigurationDescription
         *        The Amazon Glue Data Catalog that is associated with the Kinesis Data Analytics Studio notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogConfigurationDescription(CatalogConfigurationDescription catalogConfigurationDescription);

        /**
         * <p>
         * The Amazon Glue Data Catalog that is associated with the Kinesis Data Analytics Studio notebook.
         * </p>
         * This is a convenience method that creates an instance of the {@link CatalogConfigurationDescription.Builder}
         * avoiding the need to create one manually via {@link CatalogConfigurationDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CatalogConfigurationDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #catalogConfigurationDescription(CatalogConfigurationDescription)}.
         * 
         * @param catalogConfigurationDescription
         *        a consumer that will call methods on {@link CatalogConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogConfigurationDescription(CatalogConfigurationDescription)
         */
        default Builder catalogConfigurationDescription(
                Consumer<CatalogConfigurationDescription.Builder> catalogConfigurationDescription) {
            return catalogConfigurationDescription(CatalogConfigurationDescription.builder()
                    .applyMutation(catalogConfigurationDescription).build());
        }

        /**
         * <p>
         * The parameters required to deploy a Kinesis Data Analytics Studio notebook as an application with durable
         * state.
         * </p>
         * 
         * @param deployAsApplicationConfigurationDescription
         *        The parameters required to deploy a Kinesis Data Analytics Studio notebook as an application with
         *        durable state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployAsApplicationConfigurationDescription(
                DeployAsApplicationConfigurationDescription deployAsApplicationConfigurationDescription);

        /**
         * <p>
         * The parameters required to deploy a Kinesis Data Analytics Studio notebook as an application with durable
         * state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DeployAsApplicationConfigurationDescription.Builder} avoiding the need to create one manually via
         * {@link DeployAsApplicationConfigurationDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeployAsApplicationConfigurationDescription.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #deployAsApplicationConfigurationDescription(DeployAsApplicationConfigurationDescription)}.
         * 
         * @param deployAsApplicationConfigurationDescription
         *        a consumer that will call methods on {@link DeployAsApplicationConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deployAsApplicationConfigurationDescription(DeployAsApplicationConfigurationDescription)
         */
        default Builder deployAsApplicationConfigurationDescription(
                Consumer<DeployAsApplicationConfigurationDescription.Builder> deployAsApplicationConfigurationDescription) {
            return deployAsApplicationConfigurationDescription(DeployAsApplicationConfigurationDescription.builder()
                    .applyMutation(deployAsApplicationConfigurationDescription).build());
        }

        /**
         * <p>
         * Custom artifacts are dependency JARs and user-defined functions (UDF).
         * </p>
         * 
         * @param customArtifactsConfigurationDescription
         *        Custom artifacts are dependency JARs and user-defined functions (UDF).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customArtifactsConfigurationDescription(
                Collection<CustomArtifactConfigurationDescription> customArtifactsConfigurationDescription);

        /**
         * <p>
         * Custom artifacts are dependency JARs and user-defined functions (UDF).
         * </p>
         * 
         * @param customArtifactsConfigurationDescription
         *        Custom artifacts are dependency JARs and user-defined functions (UDF).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customArtifactsConfigurationDescription(
                CustomArtifactConfigurationDescription... customArtifactsConfigurationDescription);

        /**
         * <p>
         * Custom artifacts are dependency JARs and user-defined functions (UDF).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #customArtifactsConfigurationDescription(List<CustomArtifactConfigurationDescription>)}.
         * 
         * @param customArtifactsConfigurationDescription
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customArtifactsConfigurationDescription(java.util.Collection<CustomArtifactConfigurationDescription>)
         */
        Builder customArtifactsConfigurationDescription(
                Consumer<CustomArtifactConfigurationDescription.Builder>... customArtifactsConfigurationDescription);
    }

    static final class BuilderImpl implements Builder {
        private ZeppelinMonitoringConfigurationDescription monitoringConfigurationDescription;

        private CatalogConfigurationDescription catalogConfigurationDescription;

        private DeployAsApplicationConfigurationDescription deployAsApplicationConfigurationDescription;

        private List<CustomArtifactConfigurationDescription> customArtifactsConfigurationDescription = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ZeppelinApplicationConfigurationDescription model) {
            monitoringConfigurationDescription(model.monitoringConfigurationDescription);
            catalogConfigurationDescription(model.catalogConfigurationDescription);
            deployAsApplicationConfigurationDescription(model.deployAsApplicationConfigurationDescription);
            customArtifactsConfigurationDescription(model.customArtifactsConfigurationDescription);
        }

        public final ZeppelinMonitoringConfigurationDescription.Builder getMonitoringConfigurationDescription() {
            return monitoringConfigurationDescription != null ? monitoringConfigurationDescription.toBuilder() : null;
        }

        public final void setMonitoringConfigurationDescription(
                ZeppelinMonitoringConfigurationDescription.BuilderImpl monitoringConfigurationDescription) {
            this.monitoringConfigurationDescription = monitoringConfigurationDescription != null ? monitoringConfigurationDescription
                    .build() : null;
        }

        @Override
        public final Builder monitoringConfigurationDescription(
                ZeppelinMonitoringConfigurationDescription monitoringConfigurationDescription) {
            this.monitoringConfigurationDescription = monitoringConfigurationDescription;
            return this;
        }

        public final CatalogConfigurationDescription.Builder getCatalogConfigurationDescription() {
            return catalogConfigurationDescription != null ? catalogConfigurationDescription.toBuilder() : null;
        }

        public final void setCatalogConfigurationDescription(
                CatalogConfigurationDescription.BuilderImpl catalogConfigurationDescription) {
            this.catalogConfigurationDescription = catalogConfigurationDescription != null ? catalogConfigurationDescription
                    .build() : null;
        }

        @Override
        public final Builder catalogConfigurationDescription(CatalogConfigurationDescription catalogConfigurationDescription) {
            this.catalogConfigurationDescription = catalogConfigurationDescription;
            return this;
        }

        public final DeployAsApplicationConfigurationDescription.Builder getDeployAsApplicationConfigurationDescription() {
            return deployAsApplicationConfigurationDescription != null ? deployAsApplicationConfigurationDescription.toBuilder()
                    : null;
        }

        public final void setDeployAsApplicationConfigurationDescription(
                DeployAsApplicationConfigurationDescription.BuilderImpl deployAsApplicationConfigurationDescription) {
            this.deployAsApplicationConfigurationDescription = deployAsApplicationConfigurationDescription != null ? deployAsApplicationConfigurationDescription
                    .build() : null;
        }

        @Override
        public final Builder deployAsApplicationConfigurationDescription(
                DeployAsApplicationConfigurationDescription deployAsApplicationConfigurationDescription) {
            this.deployAsApplicationConfigurationDescription = deployAsApplicationConfigurationDescription;
            return this;
        }

        public final List<CustomArtifactConfigurationDescription.Builder> getCustomArtifactsConfigurationDescription() {
            List<CustomArtifactConfigurationDescription.Builder> result = CustomArtifactsConfigurationDescriptionListCopier
                    .copyToBuilder(this.customArtifactsConfigurationDescription);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomArtifactsConfigurationDescription(
                Collection<CustomArtifactConfigurationDescription.BuilderImpl> customArtifactsConfigurationDescription) {
            this.customArtifactsConfigurationDescription = CustomArtifactsConfigurationDescriptionListCopier
                    .copyFromBuilder(customArtifactsConfigurationDescription);
        }

        @Override
        public final Builder customArtifactsConfigurationDescription(
                Collection<CustomArtifactConfigurationDescription> customArtifactsConfigurationDescription) {
            this.customArtifactsConfigurationDescription = CustomArtifactsConfigurationDescriptionListCopier
                    .copy(customArtifactsConfigurationDescription);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customArtifactsConfigurationDescription(
                CustomArtifactConfigurationDescription... customArtifactsConfigurationDescription) {
            customArtifactsConfigurationDescription(Arrays.asList(customArtifactsConfigurationDescription));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customArtifactsConfigurationDescription(
                Consumer<CustomArtifactConfigurationDescription.Builder>... customArtifactsConfigurationDescription) {
            customArtifactsConfigurationDescription(Stream.of(customArtifactsConfigurationDescription)
                    .map(c -> CustomArtifactConfigurationDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ZeppelinApplicationConfigurationDescription build() {
            return new ZeppelinApplicationConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
