/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LogLevel {
    INFO("INFO"),
    WARN("WARN"),
    ERROR("ERROR"),
    DEBUG("DEBUG"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LogLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LogLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LogLevel.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LogLevel> knownValues() {
        return Stream.of(LogLevel.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

