/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeContent> {
    private static final SdkField<String> TEXT_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextContent").getter(CodeContent.getter(CodeContent::textContent)).setter(CodeContent.setter(Builder::textContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextContent").build()}).build();
    private static final SdkField<SdkBytes> ZIP_FILE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("ZipFileContent").getter(CodeContent.getter(CodeContent::zipFileContent)).setter(CodeContent.setter(Builder::zipFileContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipFileContent").build()}).build();
    private static final SdkField<S3ContentLocation> S3_CONTENT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3ContentLocation").getter(CodeContent.getter(CodeContent::s3ContentLocation)).setter(CodeContent.setter(Builder::s3ContentLocation)).constructor(S3ContentLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ContentLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_CONTENT_FIELD, ZIP_FILE_CONTENT_FIELD, S3_CONTENT_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String textContent;
    private final SdkBytes zipFileContent;
    private final S3ContentLocation s3ContentLocation;

    private CodeContent(BuilderImpl builder) {
        this.textContent = builder.textContent;
        this.zipFileContent = builder.zipFileContent;
        this.s3ContentLocation = builder.s3ContentLocation;
    }

    public final String textContent() {
        return this.textContent;
    }

    public final SdkBytes zipFileContent() {
        return this.zipFileContent;
    }

    public final S3ContentLocation s3ContentLocation() {
        return this.s3ContentLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.textContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.zipFileContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ContentLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeContent)) {
            return false;
        }
        CodeContent other = (CodeContent)obj;
        return Objects.equals(this.textContent(), other.textContent()) && Objects.equals(this.zipFileContent(), other.zipFileContent()) && Objects.equals(this.s3ContentLocation(), other.s3ContentLocation());
    }

    public final String toString() {
        return ToString.builder((String)"CodeContent").add("TextContent", (Object)this.textContent()).add("ZipFileContent", (Object)this.zipFileContent()).add("S3ContentLocation", (Object)this.s3ContentLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TextContent": {
                return Optional.ofNullable(clazz.cast(this.textContent()));
            }
            case "ZipFileContent": {
                return Optional.ofNullable(clazz.cast(this.zipFileContent()));
            }
            case "S3ContentLocation": {
                return Optional.ofNullable(clazz.cast(this.s3ContentLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeContent, T> g) {
        return obj -> g.apply((CodeContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String textContent;
        private SdkBytes zipFileContent;
        private S3ContentLocation s3ContentLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeContent model) {
            this.textContent(model.textContent);
            this.zipFileContent(model.zipFileContent);
            this.s3ContentLocation(model.s3ContentLocation);
        }

        public final String getTextContent() {
            return this.textContent;
        }

        @Override
        public final Builder textContent(String textContent) {
            this.textContent = textContent;
            return this;
        }

        public final void setTextContent(String textContent) {
            this.textContent = textContent;
        }

        public final ByteBuffer getZipFileContent() {
            return this.zipFileContent == null ? null : this.zipFileContent.asByteBuffer();
        }

        @Override
        public final Builder zipFileContent(SdkBytes zipFileContent) {
            this.zipFileContent = zipFileContent;
            return this;
        }

        public final void setZipFileContent(ByteBuffer zipFileContent) {
            this.zipFileContent(zipFileContent == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)zipFileContent));
        }

        public final S3ContentLocation.Builder getS3ContentLocation() {
            return this.s3ContentLocation != null ? this.s3ContentLocation.toBuilder() : null;
        }

        @Override
        public final Builder s3ContentLocation(S3ContentLocation s3ContentLocation) {
            this.s3ContentLocation = s3ContentLocation;
            return this;
        }

        public final void setS3ContentLocation(S3ContentLocation.BuilderImpl s3ContentLocation) {
            this.s3ContentLocation = s3ContentLocation != null ? s3ContentLocation.build() : null;
        }

        public CodeContent build() {
            return new CodeContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeContent> {
        public Builder textContent(String var1);

        public Builder zipFileContent(SdkBytes var1);

        public Builder s3ContentLocation(S3ContentLocation var1);

        default public Builder s3ContentLocation(Consumer<S3ContentLocation.Builder> s3ContentLocation) {
            return this.s3ContentLocation((S3ContentLocation)((S3ContentLocation.Builder)S3ContentLocation.builder().applyMutation(s3ContentLocation)).build());
        }
    }
}

