/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationUpdate;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdatesCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Request;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfigurationUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationRequest
extends KinesisAnalyticsV2Request
implements ToCopyableBuilder<Builder, UpdateApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::applicationName)).setter(UpdateApplicationRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<Long> CURRENT_APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CurrentApplicationVersionId").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::currentApplicationVersionId)).setter(UpdateApplicationRequest.setter(Builder::currentApplicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplicationVersionId").build()}).build();
    private static final SdkField<ApplicationConfigurationUpdate> APPLICATION_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationConfigurationUpdate").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::applicationConfigurationUpdate)).setter(UpdateApplicationRequest.setter(Builder::applicationConfigurationUpdate)).constructor(ApplicationConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationConfigurationUpdate").build()}).build();
    private static final SdkField<String> SERVICE_EXECUTION_ROLE_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceExecutionRoleUpdate").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::serviceExecutionRoleUpdate)).setter(UpdateApplicationRequest.setter(Builder::serviceExecutionRoleUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceExecutionRoleUpdate").build()}).build();
    private static final SdkField<RunConfigurationUpdate> RUN_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RunConfigurationUpdate").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::runConfigurationUpdate)).setter(UpdateApplicationRequest.setter(Builder::runConfigurationUpdate)).constructor(RunConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunConfigurationUpdate").build()}).build();
    private static final SdkField<List<CloudWatchLoggingOptionUpdate>> CLOUD_WATCH_LOGGING_OPTION_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CloudWatchLoggingOptionUpdates").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::cloudWatchLoggingOptionUpdates)).setter(UpdateApplicationRequest.setter(Builder::cloudWatchLoggingOptionUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptionUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchLoggingOptionUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, CURRENT_APPLICATION_VERSION_ID_FIELD, APPLICATION_CONFIGURATION_UPDATE_FIELD, SERVICE_EXECUTION_ROLE_UPDATE_FIELD, RUN_CONFIGURATION_UPDATE_FIELD, CLOUD_WATCH_LOGGING_OPTION_UPDATES_FIELD));
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final ApplicationConfigurationUpdate applicationConfigurationUpdate;
    private final String serviceExecutionRoleUpdate;
    private final RunConfigurationUpdate runConfigurationUpdate;
    private final List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.applicationConfigurationUpdate = builder.applicationConfigurationUpdate;
        this.serviceExecutionRoleUpdate = builder.serviceExecutionRoleUpdate;
        this.runConfigurationUpdate = builder.runConfigurationUpdate;
        this.cloudWatchLoggingOptionUpdates = builder.cloudWatchLoggingOptionUpdates;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public final ApplicationConfigurationUpdate applicationConfigurationUpdate() {
        return this.applicationConfigurationUpdate;
    }

    public final String serviceExecutionRoleUpdate() {
        return this.serviceExecutionRoleUpdate;
    }

    public final RunConfigurationUpdate runConfigurationUpdate() {
        return this.runConfigurationUpdate;
    }

    public final boolean hasCloudWatchLoggingOptionUpdates() {
        return this.cloudWatchLoggingOptionUpdates != null && !(this.cloudWatchLoggingOptionUpdates instanceof SdkAutoConstructList);
    }

    public final List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates() {
        return this.cloudWatchLoggingOptionUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceExecutionRoleUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.runConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudWatchLoggingOptionUpdates() ? this.cloudWatchLoggingOptionUpdates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.currentApplicationVersionId(), other.currentApplicationVersionId()) && Objects.equals(this.applicationConfigurationUpdate(), other.applicationConfigurationUpdate()) && Objects.equals(this.serviceExecutionRoleUpdate(), other.serviceExecutionRoleUpdate()) && Objects.equals(this.runConfigurationUpdate(), other.runConfigurationUpdate()) && this.hasCloudWatchLoggingOptionUpdates() == other.hasCloudWatchLoggingOptionUpdates() && Objects.equals(this.cloudWatchLoggingOptionUpdates(), other.cloudWatchLoggingOptionUpdates());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationRequest").add("ApplicationName", (Object)this.applicationName()).add("CurrentApplicationVersionId", (Object)this.currentApplicationVersionId()).add("ApplicationConfigurationUpdate", (Object)this.applicationConfigurationUpdate()).add("ServiceExecutionRoleUpdate", (Object)this.serviceExecutionRoleUpdate()).add("RunConfigurationUpdate", (Object)this.runConfigurationUpdate()).add("CloudWatchLoggingOptionUpdates", this.hasCloudWatchLoggingOptionUpdates() ? this.cloudWatchLoggingOptionUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "CurrentApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.currentApplicationVersionId()));
            }
            case "ApplicationConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.applicationConfigurationUpdate()));
            }
            case "ServiceExecutionRoleUpdate": {
                return Optional.ofNullable(clazz.cast(this.serviceExecutionRoleUpdate()));
            }
            case "RunConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.runConfigurationUpdate()));
            }
            case "CloudWatchLoggingOptionUpdates": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptionUpdates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Request.BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private ApplicationConfigurationUpdate applicationConfigurationUpdate;
        private String serviceExecutionRoleUpdate;
        private RunConfigurationUpdate runConfigurationUpdate;
        private List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.currentApplicationVersionId(model.currentApplicationVersionId);
            this.applicationConfigurationUpdate(model.applicationConfigurationUpdate);
            this.serviceExecutionRoleUpdate(model.serviceExecutionRoleUpdate);
            this.runConfigurationUpdate(model.runConfigurationUpdate);
            this.cloudWatchLoggingOptionUpdates(model.cloudWatchLoggingOptionUpdates);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final ApplicationConfigurationUpdate.Builder getApplicationConfigurationUpdate() {
            return this.applicationConfigurationUpdate != null ? this.applicationConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder applicationConfigurationUpdate(ApplicationConfigurationUpdate applicationConfigurationUpdate) {
            this.applicationConfigurationUpdate = applicationConfigurationUpdate;
            return this;
        }

        public final void setApplicationConfigurationUpdate(ApplicationConfigurationUpdate.BuilderImpl applicationConfigurationUpdate) {
            this.applicationConfigurationUpdate = applicationConfigurationUpdate != null ? applicationConfigurationUpdate.build() : null;
        }

        public final String getServiceExecutionRoleUpdate() {
            return this.serviceExecutionRoleUpdate;
        }

        @Override
        public final Builder serviceExecutionRoleUpdate(String serviceExecutionRoleUpdate) {
            this.serviceExecutionRoleUpdate = serviceExecutionRoleUpdate;
            return this;
        }

        public final void setServiceExecutionRoleUpdate(String serviceExecutionRoleUpdate) {
            this.serviceExecutionRoleUpdate = serviceExecutionRoleUpdate;
        }

        public final RunConfigurationUpdate.Builder getRunConfigurationUpdate() {
            return this.runConfigurationUpdate != null ? this.runConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder runConfigurationUpdate(RunConfigurationUpdate runConfigurationUpdate) {
            this.runConfigurationUpdate = runConfigurationUpdate;
            return this;
        }

        public final void setRunConfigurationUpdate(RunConfigurationUpdate.BuilderImpl runConfigurationUpdate) {
            this.runConfigurationUpdate = runConfigurationUpdate != null ? runConfigurationUpdate.build() : null;
        }

        public final Collection<CloudWatchLoggingOptionUpdate.Builder> getCloudWatchLoggingOptionUpdates() {
            if (this.cloudWatchLoggingOptionUpdates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cloudWatchLoggingOptionUpdates != null ? (Collection)this.cloudWatchLoggingOptionUpdates.stream().map(CloudWatchLoggingOptionUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdatesCopier.copy(cloudWatchLoggingOptionUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate ... cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates(Arrays.asList(cloudWatchLoggingOptionUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionUpdates(Consumer<CloudWatchLoggingOptionUpdate.Builder> ... cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates(Stream.of(cloudWatchLoggingOptionUpdates).map(c -> (CloudWatchLoggingOptionUpdate)((CloudWatchLoggingOptionUpdate.Builder)CloudWatchLoggingOptionUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate.BuilderImpl> cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdatesCopier.copyFromBuilder(cloudWatchLoggingOptionUpdates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder applicationConfigurationUpdate(ApplicationConfigurationUpdate var1);

        default public Builder applicationConfigurationUpdate(Consumer<ApplicationConfigurationUpdate.Builder> applicationConfigurationUpdate) {
            return this.applicationConfigurationUpdate((ApplicationConfigurationUpdate)((ApplicationConfigurationUpdate.Builder)ApplicationConfigurationUpdate.builder().applyMutation(applicationConfigurationUpdate)).build());
        }

        public Builder serviceExecutionRoleUpdate(String var1);

        public Builder runConfigurationUpdate(RunConfigurationUpdate var1);

        default public Builder runConfigurationUpdate(Consumer<RunConfigurationUpdate.Builder> runConfigurationUpdate) {
            return this.runConfigurationUpdate((RunConfigurationUpdate)((RunConfigurationUpdate.Builder)RunConfigurationUpdate.builder().applyMutation(runConfigurationUpdate)).build());
        }

        public Builder cloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate> var1);

        public Builder cloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate ... var1);

        public Builder cloudWatchLoggingOptionUpdates(Consumer<CloudWatchLoggingOptionUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

