/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Request;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UrlType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationPresignedUrlRequest
extends KinesisAnalyticsV2Request
implements ToCopyableBuilder<Builder, CreateApplicationPresignedUrlRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(CreateApplicationPresignedUrlRequest.getter(CreateApplicationPresignedUrlRequest::applicationName)).setter(CreateApplicationPresignedUrlRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> URL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UrlType").getter(CreateApplicationPresignedUrlRequest.getter(CreateApplicationPresignedUrlRequest::urlTypeAsString)).setter(CreateApplicationPresignedUrlRequest.setter(Builder::urlType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlType").build()}).build();
    private static final SdkField<Long> SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SessionExpirationDurationInSeconds").getter(CreateApplicationPresignedUrlRequest.getter(CreateApplicationPresignedUrlRequest::sessionExpirationDurationInSeconds)).setter(CreateApplicationPresignedUrlRequest.setter(Builder::sessionExpirationDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionExpirationDurationInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, URL_TYPE_FIELD, SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD));
    private final String applicationName;
    private final String urlType;
    private final Long sessionExpirationDurationInSeconds;

    private CreateApplicationPresignedUrlRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.urlType = builder.urlType;
        this.sessionExpirationDurationInSeconds = builder.sessionExpirationDurationInSeconds;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public UrlType urlType() {
        return UrlType.fromValue(this.urlType);
    }

    public String urlTypeAsString() {
        return this.urlType;
    }

    public Long sessionExpirationDurationInSeconds() {
        return this.sessionExpirationDurationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionExpirationDurationInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationPresignedUrlRequest)) {
            return false;
        }
        CreateApplicationPresignedUrlRequest other = (CreateApplicationPresignedUrlRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.urlTypeAsString(), other.urlTypeAsString()) && Objects.equals(this.sessionExpirationDurationInSeconds(), other.sessionExpirationDurationInSeconds());
    }

    public String toString() {
        return ToString.builder((String)"CreateApplicationPresignedUrlRequest").add("ApplicationName", (Object)this.applicationName()).add("UrlType", (Object)this.urlTypeAsString()).add("SessionExpirationDurationInSeconds", (Object)this.sessionExpirationDurationInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "UrlType": {
                return Optional.ofNullable(clazz.cast(this.urlTypeAsString()));
            }
            case "SessionExpirationDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.sessionExpirationDurationInSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationPresignedUrlRequest, T> g) {
        return obj -> g.apply((CreateApplicationPresignedUrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Request.BuilderImpl
    implements Builder {
        private String applicationName;
        private String urlType;
        private Long sessionExpirationDurationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationPresignedUrlRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.urlType(model.urlType);
            this.sessionExpirationDurationInSeconds(model.sessionExpirationDurationInSeconds);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getUrlType() {
            return this.urlType;
        }

        @Override
        public final Builder urlType(String urlType) {
            this.urlType = urlType;
            return this;
        }

        @Override
        public final Builder urlType(UrlType urlType) {
            this.urlType(urlType == null ? null : urlType.toString());
            return this;
        }

        public final void setUrlType(String urlType) {
            this.urlType = urlType;
        }

        public final Long getSessionExpirationDurationInSeconds() {
            return this.sessionExpirationDurationInSeconds;
        }

        @Override
        public final Builder sessionExpirationDurationInSeconds(Long sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
            return this;
        }

        public final void setSessionExpirationDurationInSeconds(Long sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationPresignedUrlRequest build() {
            return new CreateApplicationPresignedUrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationPresignedUrlRequest> {
        public Builder applicationName(String var1);

        public Builder urlType(String var1);

        public Builder urlType(UrlType var1);

        public Builder sessionExpirationDurationInSeconds(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

