/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordColumn;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordColumnsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputSchemaUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputSchemaUpdate> {
    private static final SdkField<RecordFormat> RECORD_FORMAT_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecordFormatUpdate").getter(InputSchemaUpdate.getter(InputSchemaUpdate::recordFormatUpdate)).setter(InputSchemaUpdate.setter(Builder::recordFormatUpdate)).constructor(RecordFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordFormatUpdate").build()}).build();
    private static final SdkField<String> RECORD_ENCODING_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordEncodingUpdate").getter(InputSchemaUpdate.getter(InputSchemaUpdate::recordEncodingUpdate)).setter(InputSchemaUpdate.setter(Builder::recordEncodingUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordEncodingUpdate").build()}).build();
    private static final SdkField<List<RecordColumn>> RECORD_COLUMN_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecordColumnUpdates").getter(InputSchemaUpdate.getter(InputSchemaUpdate::recordColumnUpdates)).setter(InputSchemaUpdate.setter(Builder::recordColumnUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordColumnUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecordColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_FORMAT_UPDATE_FIELD, RECORD_ENCODING_UPDATE_FIELD, RECORD_COLUMN_UPDATES_FIELD));
    private static final long serialVersionUID = 1L;
    private final RecordFormat recordFormatUpdate;
    private final String recordEncodingUpdate;
    private final List<RecordColumn> recordColumnUpdates;

    private InputSchemaUpdate(BuilderImpl builder) {
        this.recordFormatUpdate = builder.recordFormatUpdate;
        this.recordEncodingUpdate = builder.recordEncodingUpdate;
        this.recordColumnUpdates = builder.recordColumnUpdates;
    }

    public RecordFormat recordFormatUpdate() {
        return this.recordFormatUpdate;
    }

    public String recordEncodingUpdate() {
        return this.recordEncodingUpdate;
    }

    public boolean hasRecordColumnUpdates() {
        return this.recordColumnUpdates != null && !(this.recordColumnUpdates instanceof SdkAutoConstructList);
    }

    public List<RecordColumn> recordColumnUpdates() {
        return this.recordColumnUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordFormatUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordEncodingUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordColumnUpdates() ? this.recordColumnUpdates() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSchemaUpdate)) {
            return false;
        }
        InputSchemaUpdate other = (InputSchemaUpdate)obj;
        return Objects.equals(this.recordFormatUpdate(), other.recordFormatUpdate()) && Objects.equals(this.recordEncodingUpdate(), other.recordEncodingUpdate()) && this.hasRecordColumnUpdates() == other.hasRecordColumnUpdates() && Objects.equals(this.recordColumnUpdates(), other.recordColumnUpdates());
    }

    public String toString() {
        return ToString.builder((String)"InputSchemaUpdate").add("RecordFormatUpdate", (Object)this.recordFormatUpdate()).add("RecordEncodingUpdate", (Object)this.recordEncodingUpdate()).add("RecordColumnUpdates", this.hasRecordColumnUpdates() ? this.recordColumnUpdates() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordFormatUpdate": {
                return Optional.ofNullable(clazz.cast(this.recordFormatUpdate()));
            }
            case "RecordEncodingUpdate": {
                return Optional.ofNullable(clazz.cast(this.recordEncodingUpdate()));
            }
            case "RecordColumnUpdates": {
                return Optional.ofNullable(clazz.cast(this.recordColumnUpdates()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputSchemaUpdate, T> g) {
        return obj -> g.apply((InputSchemaUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RecordFormat recordFormatUpdate;
        private String recordEncodingUpdate;
        private List<RecordColumn> recordColumnUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputSchemaUpdate model) {
            this.recordFormatUpdate(model.recordFormatUpdate);
            this.recordEncodingUpdate(model.recordEncodingUpdate);
            this.recordColumnUpdates(model.recordColumnUpdates);
        }

        public final RecordFormat.Builder getRecordFormatUpdate() {
            return this.recordFormatUpdate != null ? this.recordFormatUpdate.toBuilder() : null;
        }

        @Override
        public final Builder recordFormatUpdate(RecordFormat recordFormatUpdate) {
            this.recordFormatUpdate = recordFormatUpdate;
            return this;
        }

        public final void setRecordFormatUpdate(RecordFormat.BuilderImpl recordFormatUpdate) {
            this.recordFormatUpdate = recordFormatUpdate != null ? recordFormatUpdate.build() : null;
        }

        public final String getRecordEncodingUpdate() {
            return this.recordEncodingUpdate;
        }

        @Override
        public final Builder recordEncodingUpdate(String recordEncodingUpdate) {
            this.recordEncodingUpdate = recordEncodingUpdate;
            return this;
        }

        public final void setRecordEncodingUpdate(String recordEncodingUpdate) {
            this.recordEncodingUpdate = recordEncodingUpdate;
        }

        public final Collection<RecordColumn.Builder> getRecordColumnUpdates() {
            if (this.recordColumnUpdates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recordColumnUpdates != null ? (Collection)this.recordColumnUpdates.stream().map(RecordColumn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordColumnUpdates(Collection<RecordColumn> recordColumnUpdates) {
            this.recordColumnUpdates = RecordColumnsCopier.copy(recordColumnUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordColumnUpdates(RecordColumn ... recordColumnUpdates) {
            this.recordColumnUpdates(Arrays.asList(recordColumnUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordColumnUpdates(Consumer<RecordColumn.Builder> ... recordColumnUpdates) {
            this.recordColumnUpdates(Stream.of(recordColumnUpdates).map(c -> (RecordColumn)((RecordColumn.Builder)RecordColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecordColumnUpdates(Collection<RecordColumn.BuilderImpl> recordColumnUpdates) {
            this.recordColumnUpdates = RecordColumnsCopier.copyFromBuilder(recordColumnUpdates);
        }

        public InputSchemaUpdate build() {
            return new InputSchemaUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputSchemaUpdate> {
        public Builder recordFormatUpdate(RecordFormat var1);

        default public Builder recordFormatUpdate(Consumer<RecordFormat.Builder> recordFormatUpdate) {
            return this.recordFormatUpdate((RecordFormat)((RecordFormat.Builder)RecordFormat.builder().applyMutation(recordFormatUpdate)).build());
        }

        public Builder recordEncodingUpdate(String var1);

        public Builder recordColumnUpdates(Collection<RecordColumn> var1);

        public Builder recordColumnUpdates(RecordColumn ... var1);

        public Builder recordColumnUpdates(Consumer<RecordColumn.Builder> ... var1);
    }
}

