/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlinkApplicationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlinkApplicationConfiguration> {
    private static final SdkField<CheckpointConfiguration> CHECKPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CheckpointConfiguration").getter(FlinkApplicationConfiguration.getter(FlinkApplicationConfiguration::checkpointConfiguration)).setter(FlinkApplicationConfiguration.setter(Builder::checkpointConfiguration)).constructor(CheckpointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointConfiguration").build()}).build();
    private static final SdkField<MonitoringConfiguration> MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitoringConfiguration").getter(FlinkApplicationConfiguration.getter(FlinkApplicationConfiguration::monitoringConfiguration)).setter(FlinkApplicationConfiguration.setter(Builder::monitoringConfiguration)).constructor(MonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringConfiguration").build()}).build();
    private static final SdkField<ParallelismConfiguration> PARALLELISM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParallelismConfiguration").getter(FlinkApplicationConfiguration.getter(FlinkApplicationConfiguration::parallelismConfiguration)).setter(FlinkApplicationConfiguration.setter(Builder::parallelismConfiguration)).constructor(ParallelismConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKPOINT_CONFIGURATION_FIELD, MONITORING_CONFIGURATION_FIELD, PARALLELISM_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final CheckpointConfiguration checkpointConfiguration;
    private final MonitoringConfiguration monitoringConfiguration;
    private final ParallelismConfiguration parallelismConfiguration;

    private FlinkApplicationConfiguration(BuilderImpl builder) {
        this.checkpointConfiguration = builder.checkpointConfiguration;
        this.monitoringConfiguration = builder.monitoringConfiguration;
        this.parallelismConfiguration = builder.parallelismConfiguration;
    }

    public CheckpointConfiguration checkpointConfiguration() {
        return this.checkpointConfiguration;
    }

    public MonitoringConfiguration monitoringConfiguration() {
        return this.monitoringConfiguration;
    }

    public ParallelismConfiguration parallelismConfiguration() {
        return this.parallelismConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelismConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlinkApplicationConfiguration)) {
            return false;
        }
        FlinkApplicationConfiguration other = (FlinkApplicationConfiguration)obj;
        return Objects.equals(this.checkpointConfiguration(), other.checkpointConfiguration()) && Objects.equals(this.monitoringConfiguration(), other.monitoringConfiguration()) && Objects.equals(this.parallelismConfiguration(), other.parallelismConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"FlinkApplicationConfiguration").add("CheckpointConfiguration", (Object)this.checkpointConfiguration()).add("MonitoringConfiguration", (Object)this.monitoringConfiguration()).add("ParallelismConfiguration", (Object)this.parallelismConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CheckpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.checkpointConfiguration()));
            }
            case "MonitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.monitoringConfiguration()));
            }
            case "ParallelismConfiguration": {
                return Optional.ofNullable(clazz.cast(this.parallelismConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlinkApplicationConfiguration, T> g) {
        return obj -> g.apply((FlinkApplicationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CheckpointConfiguration checkpointConfiguration;
        private MonitoringConfiguration monitoringConfiguration;
        private ParallelismConfiguration parallelismConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FlinkApplicationConfiguration model) {
            this.checkpointConfiguration(model.checkpointConfiguration);
            this.monitoringConfiguration(model.monitoringConfiguration);
            this.parallelismConfiguration(model.parallelismConfiguration);
        }

        public final CheckpointConfiguration.Builder getCheckpointConfiguration() {
            return this.checkpointConfiguration != null ? this.checkpointConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder checkpointConfiguration(CheckpointConfiguration checkpointConfiguration) {
            this.checkpointConfiguration = checkpointConfiguration;
            return this;
        }

        public final void setCheckpointConfiguration(CheckpointConfiguration.BuilderImpl checkpointConfiguration) {
            this.checkpointConfiguration = checkpointConfiguration != null ? checkpointConfiguration.build() : null;
        }

        public final MonitoringConfiguration.Builder getMonitoringConfiguration() {
            return this.monitoringConfiguration != null ? this.monitoringConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder monitoringConfiguration(MonitoringConfiguration monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration;
            return this;
        }

        public final void setMonitoringConfiguration(MonitoringConfiguration.BuilderImpl monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration != null ? monitoringConfiguration.build() : null;
        }

        public final ParallelismConfiguration.Builder getParallelismConfiguration() {
            return this.parallelismConfiguration != null ? this.parallelismConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration;
            return this;
        }

        public final void setParallelismConfiguration(ParallelismConfiguration.BuilderImpl parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration != null ? parallelismConfiguration.build() : null;
        }

        public FlinkApplicationConfiguration build() {
            return new FlinkApplicationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlinkApplicationConfiguration> {
        public Builder checkpointConfiguration(CheckpointConfiguration var1);

        default public Builder checkpointConfiguration(Consumer<CheckpointConfiguration.Builder> checkpointConfiguration) {
            return this.checkpointConfiguration((CheckpointConfiguration)((CheckpointConfiguration.Builder)CheckpointConfiguration.builder().applyMutation(checkpointConfiguration)).build());
        }

        public Builder monitoringConfiguration(MonitoringConfiguration var1);

        default public Builder monitoringConfiguration(Consumer<MonitoringConfiguration.Builder> monitoringConfiguration) {
            return this.monitoringConfiguration((MonitoringConfiguration)((MonitoringConfiguration.Builder)MonitoringConfiguration.builder().applyMutation(monitoringConfiguration)).build());
        }

        public Builder parallelismConfiguration(ParallelismConfiguration var1);

        default public Builder parallelismConfiguration(Consumer<ParallelismConfiguration.Builder> parallelismConfiguration) {
            return this.parallelismConfiguration((ParallelismConfiguration)((ParallelismConfiguration.Builder)ParallelismConfiguration.builder().applyMutation(parallelismConfiguration)).build());
        }
    }
}

