/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentPropertyUpdates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentPropertyUpdates> {
    private static final SdkField<List<PropertyGroup>> PROPERTY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PropertyGroups").getter(EnvironmentPropertyUpdates.getter(EnvironmentPropertyUpdates::propertyGroups)).setter(EnvironmentPropertyUpdates.setter(Builder::propertyGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_GROUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<PropertyGroup> propertyGroups;

    private EnvironmentPropertyUpdates(BuilderImpl builder) {
        this.propertyGroups = builder.propertyGroups;
    }

    public boolean hasPropertyGroups() {
        return this.propertyGroups != null && !(this.propertyGroups instanceof SdkAutoConstructList);
    }

    public List<PropertyGroup> propertyGroups() {
        return this.propertyGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentPropertyUpdates)) {
            return false;
        }
        EnvironmentPropertyUpdates other = (EnvironmentPropertyUpdates)obj;
        return Objects.equals(this.propertyGroups(), other.propertyGroups());
    }

    public String toString() {
        return ToString.builder((String)"EnvironmentPropertyUpdates").add("PropertyGroups", this.propertyGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PropertyGroups": {
                return Optional.ofNullable(clazz.cast(this.propertyGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentPropertyUpdates, T> g) {
        return obj -> g.apply((EnvironmentPropertyUpdates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PropertyGroup> propertyGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentPropertyUpdates model) {
            this.propertyGroups(model.propertyGroups);
        }

        public final Collection<PropertyGroup.Builder> getPropertyGroups() {
            return this.propertyGroups != null ? (Collection)this.propertyGroups.stream().map(PropertyGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder propertyGroups(Collection<PropertyGroup> propertyGroups) {
            this.propertyGroups = PropertyGroupsCopier.copy(propertyGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyGroups(PropertyGroup ... propertyGroups) {
            this.propertyGroups(Arrays.asList(propertyGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyGroups(Consumer<PropertyGroup.Builder> ... propertyGroups) {
            this.propertyGroups(Stream.of(propertyGroups).map(c -> (PropertyGroup)((PropertyGroup.Builder)PropertyGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPropertyGroups(Collection<PropertyGroup.BuilderImpl> propertyGroups) {
            this.propertyGroups = PropertyGroupsCopier.copyFromBuilder(propertyGroups);
        }

        public EnvironmentPropertyUpdates build() {
            return new EnvironmentPropertyUpdates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentPropertyUpdates> {
        public Builder propertyGroups(Collection<PropertyGroup> var1);

        public Builder propertyGroups(PropertyGroup ... var1);

        public Builder propertyGroups(Consumer<PropertyGroup.Builder> ... var1);
    }
}

