/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Response;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotDetails;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotSummariesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationSnapshotsResponse
extends KinesisAnalyticsV2Response
implements ToCopyableBuilder<Builder, ListApplicationSnapshotsResponse> {
    private static final SdkField<List<SnapshotDetails>> SNAPSHOT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListApplicationSnapshotsResponse.getter(ListApplicationSnapshotsResponse::snapshotSummaries)).setter(ListApplicationSnapshotsResponse.setter(Builder::snapshotSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListApplicationSnapshotsResponse.getter(ListApplicationSnapshotsResponse::nextToken)).setter(ListApplicationSnapshotsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<SnapshotDetails> snapshotSummaries;
    private final String nextToken;

    private ListApplicationSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotSummaries = builder.snapshotSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasSnapshotSummaries() {
        return this.snapshotSummaries != null && !(this.snapshotSummaries instanceof SdkAutoConstructList);
    }

    public List<SnapshotDetails> snapshotSummaries() {
        return this.snapshotSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationSnapshotsResponse)) {
            return false;
        }
        ListApplicationSnapshotsResponse other = (ListApplicationSnapshotsResponse)((Object)obj);
        return Objects.equals(this.snapshotSummaries(), other.snapshotSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListApplicationSnapshotsResponse").add("SnapshotSummaries", this.snapshotSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotSummaries": {
                return Optional.ofNullable(clazz.cast(this.snapshotSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationSnapshotsResponse, T> g) {
        return obj -> g.apply((ListApplicationSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Response.BuilderImpl
    implements Builder {
        private List<SnapshotDetails> snapshotSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationSnapshotsResponse model) {
            super(model);
            this.snapshotSummaries(model.snapshotSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<SnapshotDetails.Builder> getSnapshotSummaries() {
            return this.snapshotSummaries != null ? (Collection)this.snapshotSummaries.stream().map(SnapshotDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder snapshotSummaries(Collection<SnapshotDetails> snapshotSummaries) {
            this.snapshotSummaries = SnapshotSummariesCopier.copy(snapshotSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotSummaries(SnapshotDetails ... snapshotSummaries) {
            this.snapshotSummaries(Arrays.asList(snapshotSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotSummaries(Consumer<SnapshotDetails.Builder> ... snapshotSummaries) {
            this.snapshotSummaries(Stream.of(snapshotSummaries).map(c -> (SnapshotDetails)((SnapshotDetails.Builder)SnapshotDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSnapshotSummaries(Collection<SnapshotDetails.BuilderImpl> snapshotSummaries) {
            this.snapshotSummaries = SnapshotSummariesCopier.copyFromBuilder(snapshotSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListApplicationSnapshotsResponse build() {
            return new ListApplicationSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationSnapshotsResponse> {
        public Builder snapshotSummaries(Collection<SnapshotDetails> var1);

        public Builder snapshotSummaries(SnapshotDetails ... var1);

        public Builder snapshotSummaries(Consumer<SnapshotDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

