/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferenceDataSourceDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReferenceDataSourceDescription> {
    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReferenceDataSourceDescription.getter(ReferenceDataSourceDescription::referenceId)).setter(ReferenceDataSourceDescription.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReferenceDataSourceDescription.getter(ReferenceDataSourceDescription::tableName)).setter(ReferenceDataSourceDescription.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<S3ReferenceDataSourceDescription> S3_REFERENCE_DATA_SOURCE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReferenceDataSourceDescription.getter(ReferenceDataSourceDescription::s3ReferenceDataSourceDescription)).setter(ReferenceDataSourceDescription.setter(Builder::s3ReferenceDataSourceDescription)).constructor(S3ReferenceDataSourceDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ReferenceDataSourceDescription").build()}).build();
    private static final SdkField<SourceSchema> REFERENCE_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReferenceDataSourceDescription.getter(ReferenceDataSourceDescription::referenceSchema)).setter(ReferenceDataSourceDescription.setter(Builder::referenceSchema)).constructor(SourceSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceSchema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_ID_FIELD, TABLE_NAME_FIELD, S3_REFERENCE_DATA_SOURCE_DESCRIPTION_FIELD, REFERENCE_SCHEMA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String referenceId;
    private final String tableName;
    private final S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription;
    private final SourceSchema referenceSchema;

    private ReferenceDataSourceDescription(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.tableName = builder.tableName;
        this.s3ReferenceDataSourceDescription = builder.s3ReferenceDataSourceDescription;
        this.referenceSchema = builder.referenceSchema;
    }

    public String referenceId() {
        return this.referenceId;
    }

    public String tableName() {
        return this.tableName;
    }

    public S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription() {
        return this.s3ReferenceDataSourceDescription;
    }

    public SourceSchema referenceSchema() {
        return this.referenceSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ReferenceDataSourceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceSchema());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSourceDescription)) {
            return false;
        }
        ReferenceDataSourceDescription other = (ReferenceDataSourceDescription)obj;
        return Objects.equals(this.referenceId(), other.referenceId()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.s3ReferenceDataSourceDescription(), other.s3ReferenceDataSourceDescription()) && Objects.equals(this.referenceSchema(), other.referenceSchema());
    }

    public String toString() {
        return ToString.builder((String)"ReferenceDataSourceDescription").add("ReferenceId", (Object)this.referenceId()).add("TableName", (Object)this.tableName()).add("S3ReferenceDataSourceDescription", (Object)this.s3ReferenceDataSourceDescription()).add("ReferenceSchema", (Object)this.referenceSchema()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReferenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "S3ReferenceDataSourceDescription": {
                return Optional.ofNullable(clazz.cast(this.s3ReferenceDataSourceDescription()));
            }
            case "ReferenceSchema": {
                return Optional.ofNullable(clazz.cast(this.referenceSchema()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceDataSourceDescription, T> g) {
        return obj -> g.apply((ReferenceDataSourceDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String referenceId;
        private String tableName;
        private S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription;
        private SourceSchema referenceSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSourceDescription model) {
            this.referenceId(model.referenceId);
            this.tableName(model.tableName);
            this.s3ReferenceDataSourceDescription(model.s3ReferenceDataSourceDescription);
            this.referenceSchema(model.referenceSchema);
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final S3ReferenceDataSourceDescription.Builder getS3ReferenceDataSourceDescription() {
            return this.s3ReferenceDataSourceDescription != null ? this.s3ReferenceDataSourceDescription.toBuilder() : null;
        }

        @Override
        public final Builder s3ReferenceDataSourceDescription(S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription) {
            this.s3ReferenceDataSourceDescription = s3ReferenceDataSourceDescription;
            return this;
        }

        public final void setS3ReferenceDataSourceDescription(S3ReferenceDataSourceDescription.BuilderImpl s3ReferenceDataSourceDescription) {
            this.s3ReferenceDataSourceDescription = s3ReferenceDataSourceDescription != null ? s3ReferenceDataSourceDescription.build() : null;
        }

        public final SourceSchema.Builder getReferenceSchema() {
            return this.referenceSchema != null ? this.referenceSchema.toBuilder() : null;
        }

        @Override
        public final Builder referenceSchema(SourceSchema referenceSchema) {
            this.referenceSchema = referenceSchema;
            return this;
        }

        public final void setReferenceSchema(SourceSchema.BuilderImpl referenceSchema) {
            this.referenceSchema = referenceSchema != null ? referenceSchema.build() : null;
        }

        public ReferenceDataSourceDescription build() {
            return new ReferenceDataSourceDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReferenceDataSourceDescription> {
        public Builder referenceId(String var1);

        public Builder tableName(String var1);

        public Builder s3ReferenceDataSourceDescription(S3ReferenceDataSourceDescription var1);

        default public Builder s3ReferenceDataSourceDescription(Consumer<S3ReferenceDataSourceDescription.Builder> s3ReferenceDataSourceDescription) {
            return this.s3ReferenceDataSourceDescription((S3ReferenceDataSourceDescription)((S3ReferenceDataSourceDescription.Builder)S3ReferenceDataSourceDescription.builder().applyMutation(s3ReferenceDataSourceDescription)).build());
        }

        public Builder referenceSchema(SourceSchema var1);

        default public Builder referenceSchema(Consumer<SourceSchema.Builder> referenceSchema) {
            return this.referenceSchema((SourceSchema)((SourceSchema.Builder)SourceSchema.builder().applyMutation(referenceSchema)).build());
        }
    }
}

