/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddApplicationReferenceDataSourceRequest
extends KinesisAnalyticsRequest
implements ToCopyableBuilder<Builder, AddApplicationReferenceDataSourceRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddApplicationReferenceDataSourceRequest.getter(AddApplicationReferenceDataSourceRequest::applicationName)).setter(AddApplicationReferenceDataSourceRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<Long> CURRENT_APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(AddApplicationReferenceDataSourceRequest.getter(AddApplicationReferenceDataSourceRequest::currentApplicationVersionId)).setter(AddApplicationReferenceDataSourceRequest.setter(Builder::currentApplicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplicationVersionId").build()}).build();
    private static final SdkField<ReferenceDataSource> REFERENCE_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AddApplicationReferenceDataSourceRequest.getter(AddApplicationReferenceDataSourceRequest::referenceDataSource)).setter(AddApplicationReferenceDataSourceRequest.setter(Builder::referenceDataSource)).constructor(ReferenceDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceDataSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, CURRENT_APPLICATION_VERSION_ID_FIELD, REFERENCE_DATA_SOURCE_FIELD));
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final ReferenceDataSource referenceDataSource;

    private AddApplicationReferenceDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.referenceDataSource = builder.referenceDataSource;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public ReferenceDataSource referenceDataSource() {
        return this.referenceDataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceDataSource());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationReferenceDataSourceRequest)) {
            return false;
        }
        AddApplicationReferenceDataSourceRequest other = (AddApplicationReferenceDataSourceRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.currentApplicationVersionId(), other.currentApplicationVersionId()) && Objects.equals(this.referenceDataSource(), other.referenceDataSource());
    }

    public String toString() {
        return ToString.builder((String)"AddApplicationReferenceDataSourceRequest").add("ApplicationName", (Object)this.applicationName()).add("CurrentApplicationVersionId", (Object)this.currentApplicationVersionId()).add("ReferenceDataSource", (Object)this.referenceDataSource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "CurrentApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.currentApplicationVersionId()));
            }
            case "ReferenceDataSource": {
                return Optional.ofNullable(clazz.cast(this.referenceDataSource()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationReferenceDataSourceRequest, T> g) {
        return obj -> g.apply((AddApplicationReferenceDataSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private ReferenceDataSource referenceDataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationReferenceDataSourceRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.currentApplicationVersionId(model.currentApplicationVersionId);
            this.referenceDataSource(model.referenceDataSource);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final ReferenceDataSource.Builder getReferenceDataSource() {
            return this.referenceDataSource != null ? this.referenceDataSource.toBuilder() : null;
        }

        @Override
        public final Builder referenceDataSource(ReferenceDataSource referenceDataSource) {
            this.referenceDataSource = referenceDataSource;
            return this;
        }

        public final void setReferenceDataSource(ReferenceDataSource.BuilderImpl referenceDataSource) {
            this.referenceDataSource = referenceDataSource != null ? referenceDataSource.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddApplicationReferenceDataSourceRequest build() {
            return new AddApplicationReferenceDataSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddApplicationReferenceDataSourceRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder referenceDataSource(ReferenceDataSource var1);

        default public Builder referenceDataSource(Consumer<ReferenceDataSource.Builder> referenceDataSource) {
            return this.referenceDataSource((ReferenceDataSource)((ReferenceDataSource.Builder)ReferenceDataSource.builder().applyMutation(referenceDataSource)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

