/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read the
 * Amazon S3 object on your behalf and populate the in-application reference table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ReferenceDataSourceUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ReferenceDataSourceUpdate.Builder, S3ReferenceDataSourceUpdate> {
    private static final SdkField<String> BUCKET_ARN_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketARNUpdate").getter(getter(S3ReferenceDataSourceUpdate::bucketARNUpdate))
            .setter(setter(Builder::bucketARNUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARNUpdate").build()).build();

    private static final SdkField<String> FILE_KEY_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileKeyUpdate").getter(getter(S3ReferenceDataSourceUpdate::fileKeyUpdate))
            .setter(setter(Builder::fileKeyUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileKeyUpdate").build()).build();

    private static final SdkField<String> REFERENCE_ROLE_ARN_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReferenceRoleARNUpdate").getter(getter(S3ReferenceDataSourceUpdate::referenceRoleARNUpdate))
            .setter(setter(Builder::referenceRoleARNUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceRoleARNUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_UPDATE_FIELD,
            FILE_KEY_UPDATE_FIELD, REFERENCE_ROLE_ARN_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucketARNUpdate;

    private final String fileKeyUpdate;

    private final String referenceRoleARNUpdate;

    private S3ReferenceDataSourceUpdate(BuilderImpl builder) {
        this.bucketARNUpdate = builder.bucketARNUpdate;
        this.fileKeyUpdate = builder.fileKeyUpdate;
        this.referenceRoleARNUpdate = builder.referenceRoleARNUpdate;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the S3 bucket.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the S3 bucket.
     */
    public final String bucketARNUpdate() {
        return bucketARNUpdate;
    }

    /**
     * <p>
     * Object key name.
     * </p>
     * 
     * @return Object key name.
     */
    public final String fileKeyUpdate() {
        return fileKeyUpdate;
    }

    /**
     * <p>
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate the
     * in-application.
     * </p>
     * 
     * @return ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate
     *         the in-application.
     */
    public final String referenceRoleARNUpdate() {
        return referenceRoleARNUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketARNUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(fileKeyUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(referenceRoleARNUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ReferenceDataSourceUpdate)) {
            return false;
        }
        S3ReferenceDataSourceUpdate other = (S3ReferenceDataSourceUpdate) obj;
        return Objects.equals(bucketARNUpdate(), other.bucketARNUpdate())
                && Objects.equals(fileKeyUpdate(), other.fileKeyUpdate())
                && Objects.equals(referenceRoleARNUpdate(), other.referenceRoleARNUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ReferenceDataSourceUpdate").add("BucketARNUpdate", bucketARNUpdate())
                .add("FileKeyUpdate", fileKeyUpdate()).add("ReferenceRoleARNUpdate", referenceRoleARNUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketARNUpdate":
            return Optional.ofNullable(clazz.cast(bucketARNUpdate()));
        case "FileKeyUpdate":
            return Optional.ofNullable(clazz.cast(fileKeyUpdate()));
        case "ReferenceRoleARNUpdate":
            return Optional.ofNullable(clazz.cast(referenceRoleARNUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BucketARNUpdate", BUCKET_ARN_UPDATE_FIELD);
        map.put("FileKeyUpdate", FILE_KEY_UPDATE_FIELD);
        map.put("ReferenceRoleARNUpdate", REFERENCE_ROLE_ARN_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ReferenceDataSourceUpdate, T> g) {
        return obj -> g.apply((S3ReferenceDataSourceUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ReferenceDataSourceUpdate> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the S3 bucket.
         * </p>
         * 
         * @param bucketARNUpdate
         *        Amazon Resource Name (ARN) of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARNUpdate(String bucketARNUpdate);

        /**
         * <p>
         * Object key name.
         * </p>
         * 
         * @param fileKeyUpdate
         *        Object key name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileKeyUpdate(String fileKeyUpdate);

        /**
         * <p>
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate the
         * in-application.
         * </p>
         * 
         * @param referenceRoleARNUpdate
         *        ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate
         *        the in-application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceRoleARNUpdate(String referenceRoleARNUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String bucketARNUpdate;

        private String fileKeyUpdate;

        private String referenceRoleARNUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ReferenceDataSourceUpdate model) {
            bucketARNUpdate(model.bucketARNUpdate);
            fileKeyUpdate(model.fileKeyUpdate);
            referenceRoleARNUpdate(model.referenceRoleARNUpdate);
        }

        public final String getBucketARNUpdate() {
            return bucketARNUpdate;
        }

        public final void setBucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
        }

        @Override
        public final Builder bucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
            return this;
        }

        public final String getFileKeyUpdate() {
            return fileKeyUpdate;
        }

        public final void setFileKeyUpdate(String fileKeyUpdate) {
            this.fileKeyUpdate = fileKeyUpdate;
        }

        @Override
        public final Builder fileKeyUpdate(String fileKeyUpdate) {
            this.fileKeyUpdate = fileKeyUpdate;
            return this;
        }

        public final String getReferenceRoleARNUpdate() {
            return referenceRoleARNUpdate;
        }

        public final void setReferenceRoleARNUpdate(String referenceRoleARNUpdate) {
            this.referenceRoleARNUpdate = referenceRoleARNUpdate;
        }

        @Override
        public final Builder referenceRoleARNUpdate(String referenceRoleARNUpdate) {
            this.referenceRoleARNUpdate = referenceRoleARNUpdate;
            return this;
        }

        @Override
        public S3ReferenceDataSourceUpdate build() {
            return new S3ReferenceDataSourceUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
