/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides updates to the parallelism count.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputParallelismUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<InputParallelismUpdate.Builder, InputParallelismUpdate> {
    private static final SdkField<Integer> COUNT_UPDATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CountUpdate").getter(getter(InputParallelismUpdate::countUpdate)).setter(setter(Builder::countUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer countUpdate;

    private InputParallelismUpdate(BuilderImpl builder) {
        this.countUpdate = builder.countUpdate;
    }

    /**
     * <p>
     * Number of in-application streams to create for the specified streaming source.
     * </p>
     * 
     * @return Number of in-application streams to create for the specified streaming source.
     */
    public final Integer countUpdate() {
        return countUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(countUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputParallelismUpdate)) {
            return false;
        }
        InputParallelismUpdate other = (InputParallelismUpdate) obj;
        return Objects.equals(countUpdate(), other.countUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputParallelismUpdate").add("CountUpdate", countUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CountUpdate":
            return Optional.ofNullable(clazz.cast(countUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CountUpdate", COUNT_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputParallelismUpdate, T> g) {
        return obj -> g.apply((InputParallelismUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputParallelismUpdate> {
        /**
         * <p>
         * Number of in-application streams to create for the specified streaming source.
         * </p>
         * 
         * @param countUpdate
         *        Number of in-application streams to create for the specified streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countUpdate(Integer countUpdate);
    }

    static final class BuilderImpl implements Builder {
        private Integer countUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputParallelismUpdate model) {
            countUpdate(model.countUpdate);
        }

        public final Integer getCountUpdate() {
            return countUpdate;
        }

        public final void setCountUpdate(Integer countUpdate) {
            this.countUpdate = countUpdate;
        }

        @Override
        public final Builder countUpdate(Integer countUpdate) {
            this.countUpdate = countUpdate;
            return this;
        }

        @Override
        public InputParallelismUpdate build() {
            return new InputParallelismUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
