/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateApplicationRequestModelMarshaller {
    private static final MarshallingInfo<String> APPLICATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationName").isBinary(false).build();
    private static final MarshallingInfo<Long> CURRENTAPPLICATIONVERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrentApplicationVersionId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> APPLICATIONUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationUpdate").isBinary(false).build();
    private static final UpdateApplicationRequestModelMarshaller INSTANCE = new UpdateApplicationRequestModelMarshaller();

    private UpdateApplicationRequestModelMarshaller() {
    }

    public static UpdateApplicationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateApplicationRequest updateApplicationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateApplicationRequest), (String)"updateApplicationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateApplicationRequest.applicationName(), APPLICATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)updateApplicationRequest.currentApplicationVersionId(), CURRENTAPPLICATIONVERSIONID_BINDING);
            protocolMarshaller.marshall((Object)updateApplicationRequest.applicationUpdate(), APPLICATIONUPDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

