/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3ReferenceDataSourceDescriptionMarshaller {
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketARN").isBinary(false).build();
    private static final MarshallingInfo<String> FILEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileKey").isBinary(false).build();
    private static final MarshallingInfo<String> REFERENCEROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceRoleARN").isBinary(false).build();
    private static final S3ReferenceDataSourceDescriptionMarshaller INSTANCE = new S3ReferenceDataSourceDescriptionMarshaller();

    private S3ReferenceDataSourceDescriptionMarshaller() {
    }

    public static S3ReferenceDataSourceDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3ReferenceDataSourceDescription, (String)"s3ReferenceDataSourceDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3ReferenceDataSourceDescription.bucketARN(), BUCKETARN_BINDING);
            protocolMarshaller.marshall((Object)s3ReferenceDataSourceDescription.fileKey(), FILEKEY_BINDING);
            protocolMarshaller.marshall((Object)s3ReferenceDataSourceDescription.referenceRoleARN(), REFERENCEROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

