/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReferenceDataSourceMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3REFERENCEDATASOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3ReferenceDataSource").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REFERENCESCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceSchema").isBinary(false).build();
    private static final ReferenceDataSourceMarshaller INSTANCE = new ReferenceDataSourceMarshaller();

    private ReferenceDataSourceMarshaller() {
    }

    public static ReferenceDataSourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReferenceDataSource referenceDataSource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)referenceDataSource, (String)"referenceDataSource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)referenceDataSource.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)referenceDataSource.s3ReferenceDataSource(), S3REFERENCEDATASOURCE_BINDING);
            protocolMarshaller.marshall((Object)referenceDataSource.referenceSchema(), REFERENCESCHEMA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

