/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.transform.DestinationSchemaUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisFirehoseOutputUpdateUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisStreamsOutputUpdateUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.LambdaOutputUpdateUnmarshaller;

public class OutputUpdateUnmarshaller
implements Unmarshaller<OutputUpdate, JsonUnmarshallerContext> {
    private static final OutputUpdateUnmarshaller INSTANCE = new OutputUpdateUnmarshaller();

    public OutputUpdate unmarshall(JsonUnmarshallerContext context) throws Exception {
        OutputUpdate.Builder outputUpdateBuilder = OutputUpdate.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("OutputId", targetDepth)) {
                    context.nextToken();
                    outputUpdateBuilder.outputId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NameUpdate", targetDepth)) {
                    context.nextToken();
                    outputUpdateBuilder.nameUpdate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KinesisStreamsOutputUpdate", targetDepth)) {
                    context.nextToken();
                    outputUpdateBuilder.kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdateUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("KinesisFirehoseOutputUpdate", targetDepth)) {
                    context.nextToken();
                    outputUpdateBuilder.kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdateUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LambdaOutputUpdate", targetDepth)) {
                    context.nextToken();
                    outputUpdateBuilder.lambdaOutputUpdate(LambdaOutputUpdateUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DestinationSchemaUpdate", targetDepth)) {
                    context.nextToken();
                    outputUpdateBuilder.destinationSchemaUpdate(DestinationSchemaUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (OutputUpdate)outputUpdateBuilder.build();
    }

    public static OutputUpdateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

