/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.Output;
import software.amazon.awssdk.services.kinesisanalytics.transform.DestinationSchemaUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisFirehoseOutputUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisStreamsOutputUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.LambdaOutputUnmarshaller;

public class OutputUnmarshaller
implements Unmarshaller<Output, JsonUnmarshallerContext> {
    private static final OutputUnmarshaller INSTANCE = new OutputUnmarshaller();

    public Output unmarshall(JsonUnmarshallerContext context) throws Exception {
        Output.Builder outputBuilder = Output.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    outputBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KinesisStreamsOutput", targetDepth)) {
                    context.nextToken();
                    outputBuilder.kinesisStreamsOutput(KinesisStreamsOutputUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("KinesisFirehoseOutput", targetDepth)) {
                    context.nextToken();
                    outputBuilder.kinesisFirehoseOutput(KinesisFirehoseOutputUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LambdaOutput", targetDepth)) {
                    context.nextToken();
                    outputBuilder.lambdaOutput(LambdaOutputUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DestinationSchema", targetDepth)) {
                    context.nextToken();
                    outputBuilder.destinationSchema(DestinationSchemaUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Output)outputBuilder.build();
    }

    public static OutputUnmarshaller getInstance() {
        return INSTANCE;
    }
}

