/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription;
import software.amazon.awssdk.services.kinesisanalytics.transform.DestinationSchemaUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisFirehoseOutputDescriptionUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisStreamsOutputDescriptionUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.LambdaOutputDescriptionUnmarshaller;

public class OutputDescriptionUnmarshaller
implements Unmarshaller<OutputDescription, JsonUnmarshallerContext> {
    private static final OutputDescriptionUnmarshaller INSTANCE = new OutputDescriptionUnmarshaller();

    public OutputDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        OutputDescription.Builder outputDescriptionBuilder = OutputDescription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("OutputId", targetDepth)) {
                    context.nextToken();
                    outputDescriptionBuilder.outputId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    outputDescriptionBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KinesisStreamsOutputDescription", targetDepth)) {
                    context.nextToken();
                    outputDescriptionBuilder.kinesisStreamsOutputDescription(KinesisStreamsOutputDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("KinesisFirehoseOutputDescription", targetDepth)) {
                    context.nextToken();
                    outputDescriptionBuilder.kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LambdaOutputDescription", targetDepth)) {
                    context.nextToken();
                    outputDescriptionBuilder.lambdaOutputDescription(LambdaOutputDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DestinationSchema", targetDepth)) {
                    context.nextToken();
                    outputDescriptionBuilder.destinationSchema(DestinationSchemaUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (OutputDescription)outputDescriptionBuilder.build();
    }

    public static OutputDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

