/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutputDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LambdaOutputDescriptionMarshaller {
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARN").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final LambdaOutputDescriptionMarshaller INSTANCE = new LambdaOutputDescriptionMarshaller();

    private LambdaOutputDescriptionMarshaller() {
    }

    public static LambdaOutputDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LambdaOutputDescription lambdaOutputDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)lambdaOutputDescription, (String)"lambdaOutputDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)lambdaOutputDescription.resourceARN(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)lambdaOutputDescription.roleARN(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

